<?php

namespace App\Validator\Constraints;

use App\Entity\Device\Device;
use App\Entity\Device\DeviceNetDev;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

class HasDeviceOneLinkableNetDevValidator extends ConstraintValidator
{

    public function __construct(private EntityManagerInterface $entityManager)
    {

    }
    public function validate($value, Constraint $constraint): void
    {
        if($constraint->getOptions() === $value){
            return;
        }

        if(empty($value)){
            return;
        }

        $device = $this->entityManager->getRepository(Device::class)->findOneBy(['id' => $value]);
        $isLinkableDeviceNetDevs = $device->getNetDevices()->filter(function (DeviceNetDev $entry) {
            return ($entry->getIsLinkable() === true);
        });

        if (count($isLinkableDeviceNetDevs) <> 1) {
            $this->context->buildViolation($constraint->message)
                ->addViolation();
        }
    }


}
