<?php

namespace App\Service;

use Doctrine\ORM\EntityManagerInterface;

class DbService
{

    const CONFIG_ENABLED_EMAIL_NOTIFICATIONS = 'EnabledEmailNotifications';
    const CONFIG_ENABLED_EMAIL_NOTIFICATION_TO_ADDRESS = 'EnableEmailNotificationToAddress';
    const CONFIG_NOTIFICATION_EMAIL = 'NotificationEmail';
    const CONFIG_SENDER_EMAIL = 'SenderEmail';
    const CONFIG_SMTP_SERVER = 'SmtpServer';
    const CONFIG_SMTP_PORT = 'SmtpPort';
    const CONFIG_SMTP_SECURITY = 'SmtpSecurity';
    const CONFIG_SMTP_LOGIN = 'SmtpLogin';
    const CONFIG_SMTP_PASSWORD = 'SmtpPassword';
    const CONFIG_SLACK_TOKEN = 'SlackToken';
    const CONFIG_SLACK_CHANNEL = 'SlackChannel';

    const RESULT_STR_VAL = 'strval';
    const RESULT_INT_VAL = 'intval';

    /**
     * @var EntityManagerInterface
     */
    private EntityManagerInterface $entityManager;

    /**
     * DbService constructor.
     * @param EntityManagerInterface $entityManager
     */
    public function __construct(EntityManagerInterface $entityManager){

        $this->entityManager = $entityManager;

    }

    /**
     * @return bool
     */
    public function isEnabledEmailNotifications(): bool{

        try{

            return (bool) $this->getDbConfig(self::CONFIG_ENABLED_EMAIL_NOTIFICATIONS, self::RESULT_INT_VAL);

        }catch (\Exception $exception){

            return false;

        }

    }

    /**
     * @return bool
     */
    public function isEnabledEmailNotificationToAddress(): bool{

        try{

            return (bool) $this->getDbConfig(self::CONFIG_ENABLED_EMAIL_NOTIFICATION_TO_ADDRESS, self::RESULT_INT_VAL);

        }catch (\Exception $exception){

            return false;

        }

    }

    /**
     * @return string|null
     */
    public function getNotificationEmail(): ?string {

        try{

            return $this->getDbConfig(self::CONFIG_NOTIFICATION_EMAIL);

        }catch (\Exception $exception){

            return null;

        }

    }

    /**
     * @return string|null
     */
    public function getAdminEmail(): ?string {

        try{

            return $this->getDbAdminEmail();

        }catch (\Exception $exception){

            return null;

        }

    }

        /**
     * @return string|null
     */
    public function getSenderEmail(): ?string {

        try{

            return $this->getDbConfig(self::CONFIG_SENDER_EMAIL);

        }catch (\Exception $e){

            return null;

        }

    }

    /**
     * @return string|null
     */
    public function getSmtpServer(): ?string {

        try{

            return $this->getDbConfig(self::CONFIG_SMTP_SERVER);

        }catch (\Exception $exception){

            return null;

        }

    }

    /**
     * @return int
     */
    public function getSmtpPort(): int {

        try{

            return $this->getDbConfig(self::CONFIG_SMTP_PORT, self::RESULT_INT_VAL);

        }catch (\Exception $exception){

            return 25;

        }

    }

    /**
     * @return false|mixed
     */
    public function getSmtpSecurity(): int{

        try{

            return $this->getDbConfig(self::CONFIG_SMTP_SECURITY, self::RESULT_INT_VAL);

        }catch (\Exception $exception){

            return 0;

        }

    }

    /**
     * @return string|null
     */
    public function getSmtpLogin(): ?string {

        try{

            return $this->getDbConfig(self::CONFIG_SMTP_LOGIN);

        }catch (\Exception $exception){

            return null;

        }

    }

    /**
     * @return false|mixed
     */
    public function getSmtpPassword(): ?string {

        try{

            return $this->getDbConfig(self::CONFIG_SMTP_PASSWORD);

        }catch (\Exception $exception){

            return null;

        }

    }

    /**
     * @return string|null
     */
    public function getSlackToken(): ?string {

        try{

            return $this->getDbConfig(self::CONFIG_SLACK_TOKEN);

        }catch (\Exception $exception){

            return null;

        }


    }

    /**
     * @return false|mixed
     */
    public function getSlackChannel(): ?string {

        try{

            return $this->getDbConfig(self::CONFIG_SLACK_CHANNEL);

        }catch (\Exception $exception){

            return null;

        }

    }

    /**
     * @param string $name
     * @param string $returnValType
     * @return false|mixed
     * @throws \Doctrine\DBAL\Exception
     */
    private function getDbConfig(string $name, string $returnValType = self::RESULT_STR_VAL){

        $sql = "SELECT " . $returnValType . " FROM product_conf WHERE name = :name";
        $stmt = $this->entityManager->getConnection()->prepare($sql);
        $stmt->bindValue('name', $name);
        $resultSet = $stmt->executeQuery();

        return $resultSet->fetchOne();

    }

    private function getDbAdminEmail(){

        $sql = "SELECT email FROM user WHERE id = :id";
        $stmt = $this->entityManager->getConnection()->prepare($sql);
        $stmt->bindValue('id', 1);
        $resultSet = $stmt->executeQuery();

        return $resultSet->fetchOne();

    }

}