<?php

declare(strict_types=1);

namespace App\Entity\Tunnel;

use App\Entity\Tunnel;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'tunnel_op_status_map')]
#[ORM\Entity]
class TunnelOperationStatusMapping
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var TunnelOperation
     */
    #[ORM\ManyToOne(targetEntity: Tunnel\TunnelOperation::class, inversedBy: 'operationStatusMapping')]
    #[ORM\JoinColumn(name: 'operation_id', referencedColumnName: 'id')]
    public TunnelOperation $operation;

    /**
     * @var TunnelStatus
     */
    #[ORM\ManyToOne(targetEntity: Tunnel\TunnelStatus::class, inversedBy: 'operationStatusMapping')]
    #[ORM\JoinColumn(name: 'status_id', referencedColumnName: 'id')]
    public TunnelStatus $status;

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return TunnelOperation
     */
    public function getOperation(): TunnelOperation {

        return $this->operation;

    }

    /**
     * @return TunnelStatus
     */
    public function getStatus(): TunnelStatus {

        return $this->status;

    }

}