<?php

namespace App\Service\Api;

final class Configuration extends ApiService
{

    private const PARAM_OPTID = 'optid';
    private const PARAM_OPTVAL = 'optval';

    private const URL_API_GET_CONFIGURATION = '/g/getcf';
    private const URL_API_SET_CONFIGURATION = '/g/setcf';

    /**
     *The webservices for getting and setting the options are ready:
    - https://127.0.0.1:<MAMASD_PORT>/g/getcf
    - to get the actual configuration options visible to the user (UI admin)
    - returns JSON, all the user-visible values including defaults, actual value, minimum and maximum and, most importantly, value type (type matches the type defined in DB)
    - https://127.0.0.1:<MAMASD_PORT>/g/setcf
    - for setting or unsetting one option on a user (UI admin) level. The return code is returned inside JSON. Also, the updated value is returned in JSON.
    - https://127.0.0.1:<MAMASD_PORT>/g/setcf?optid=<OPTION_STRING_ID>
    - to unset the option. The OPTION_STRING_ID is the name that is returned in the JSON from the getcf webservice mentioned above.
    - https://127.0.0.1:<MAMASD_PORT>/g/setcf?optid=<OPTION_STRING_ID>&optval=<NEW_OPTION_VALUE>
    - to set the option to a value
    - note: for bool type use empty string (optval=) to set to false. Nonempty string (any value) sets to true.
    - https://127.0.0.1:<MAMASD_PORT>/g/setcf?optid=0
    - to tell mamasd to save the values to user.ini file. Until this is called, all the updated values are stored in memory only and as such it does not survive service restart.
     */

    /**
     * @return false|mixed
     */
    public function getConfiguration(){

        return $this->getApiCall($this->baseUrl.self::URL_API_GET_CONFIGURATION);

    }

    public function setConfiguration(string $key, $value = null){

        $params = self::PARAM_OPTID . '=' . $key;

        if(is_bool($value)) {

            $value = $value ? '1' : ''; //empty string is false, any string is true like in shell

        }

        if(isset($value)){
            $params .= '&optval=' . $value;
        }

        //dump($this->baseUrl.self::URL_API_SET_CONFIGURATION . '?' . $params);
        //die();
        return $this->getApiCall($this->baseUrl.self::URL_API_SET_CONFIGURATION . '?' . $params);

    }

    public function getDummyDonfiguration() {

        $fileName = __DIR__.'/g_getcfs_response.txt';

        if(file_exists($fileName)){

            return json_decode(file_get_contents($fileName));
        }

        return [];

    }

}