<?php

declare(strict_types=1);

namespace App\Service;

use Symfony\Component\DependencyInjection\Exception\EnvNotFoundException;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

class EnvConfigurationService
{

    public function __construct( private readonly ParameterBagInterface $params)
    {

    }

    /**
     * @return bool
     */
    public function isPythonComponentsInstalled(): bool
    {

        try{
            $availableText = $this->params->get('app.pyext.available');
            if(!empty($availableText)){
                return true;
            }else{
                return false;
            }
        }catch (EnvNotFoundException $exception){
            return false;
        }

    }

}
