<?php

namespace App\Controller\Admin;

use App\Entity\Label\Label;
use App\Entity\Label\SystemLabel;
use Doctrine\Persistence\ManagerRegistry;
use Sg\DatatablesBundle\Datatable\DatatableInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController as Controller;
use Symfony\Component\HttpFoundation\Request;

class BaseController extends Controller
{

    /**
     * @param ManagerRegistry $managerRegistry
     */
    public function __construct(protected readonly ManagerRegistry $managerRegistry)
    {
    }

    /**
     * @var array|null
     */
    protected ?array $filter = null;

    /**
     * @return array
     */
    protected function getDatatableFilter(Request $request, DatatableInterface $datatable): array
    {

        $columnsData = $datatable->getColumnBuilder()->getColumns();
        $columns = [];
        $oColumns = [];

        foreach ($columnsData as $column) {
            $columns[$column->getIndex()] = $column->getTitle();
            $oColumns[$column->getIndex()] = $column;
        }

        if ($this->filter && in_array(ucfirst(key($this->filter)), $columns)) {
            $columnId = array_search(ucfirst(key($this->filter)), $columns);
            $search = $this->filter[(key($this->filter))];
            $currentFilter = $request->get('columns');
            if (($currentFilter[$columnId]['search']['value']) === '') {
                if ($currentFilter[$columnId]['data'] === 'label') {
                    //translate text to id
                    //dump($search);
                    $label = $this->managerRegistry->getRepository(Label::class)
                        ->findOneBy(['label' => $search]);
                    if ($label) {
                        $currentFilter[$columnId]['search'] = [
                            "value" => (string)$label->getId(),
                            "regex" => "false"
                        ];
                    }
                }elseif ($currentFilter[$columnId]['data'] === 'systemLabel') {
                    $label = $this->managerRegistry->getRepository(SystemLabel::class)
                        ->findOneBy(['label' => $search]);
                    if ($label) {
                        $currentFilter[$columnId]['search'] = [
                            "value" => (string) $label->getId(),
                            "regex" => "false"
                        ];
                    }
                } elseif ($currentFilter[$columnId]['data'] === 'devId') {
                    $filter = $oColumns[$columnId]->getFilter();
                    $filter->setSearchType('in');
                    $currentFilter[$columnId]['search'] = [
                        "value" => $search,
                        "regex" => "false",
                    ];
                } else {
                    $currentFilter[$columnId]['search'] = [
                            "value" => $search,
                            "regex" => "false",
                    ];
                }
            }

            $request->query->set('columns', $currentFilter);
        }

        return $request->query->all();
    }
}
