<?php

namespace App\Controller\Admin\Tools;

use App\Bundles\Sg\DatatablesBundle\Response\DatatableResponse;
use App\Controller\Admin\BaseController;
use App\DataTable\SmsHistoryDatatable;
use App\Entity\Device\Device;
use App\Entity\Device\DeviceNetDev;
use App\Entity\Tool\SimCard;
use App\Entity\Tool\SmsHistory;
use App\Entity\Tool\SmsTemplate;
use App\Form\SmsSendType;
use App\Service\Api\ApiService;
use Sg\DatatablesBundle\Datatable\DatatableFactory;
use Sg\DatatablesBundle\Response\DatatableQueryBuilder;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/admin/tools', name: 'admin_tool_')]
class SmsSenderController extends BaseController
{

    private const ARBITRARY_SMS_ID = '1';

    /**
     * @throws \Exception
     */
    #[Route(path: '/sms-sender', name: 'sms_sender_index')]
    public function smsSenderAction(Request $request,
                                    DatatableFactory $factory,
                                    DatatableResponse $responseService,): Response {

        $isAjax = $request->isXmlHttpRequest();
        $this->filter = $request->query->get('column');

        $devices = $this->managerRegistry->getRepository(Device::class)->getDevices();

        $datatable = $factory->create(SmsHistoryDatatable::class);
        $datatable->buildDatatable();

        if ($isAjax) {
            $responseService->setDatatable($datatable);

            $requestParams = $this->getDatatableFilter($request, $datatable);
            $datatableQueryBuilder = new DatatableQueryBuilder($requestParams, $datatable);
            $responseService->setDatatableQueryBuilder($datatableQueryBuilder);

            return $responseService->getResponse();
        }

        return $this->render('tool/smsSender/index.html.twig', [
            'datatable' => $datatable,
            'filter' => $this->filter,
        ]);

    }

    #[Route(path: '/sms-sender/send', name: 'sms_sender_send')]
    public function smsSendAction(Request $request, ApiService $apiService): Response {

        $devices = $this->managerRegistry->getRepository(Device::class)->getDevicesReadyToSendSms();
        $smsTemplates = $this->managerRegistry->getRepository(SmsTemplate::class)->findAll();

        $form = $this->createForm(SmsSendType::class, ['devices' => $devices, 'smsTemplates' => $smsTemplates]);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {

            $requestData = $request->request->all()['sms_send'];
            $destinationType = $requestData['destination_type'] ?? null;
            $deviceId = $requestData['device'] ?? null;
            $smsTemplateId = $requestData['template'] ?? null;
            $smsSimcardId = $requestData['destination'] ?? null;
            $msisdnText = $requestData['msisdn'] ?? null;
            $customSmsText = $requestData['custom_text'] ?? null;

            $formData = $form->getData();
            $em = $this->managerRegistry->getManager();

            //dump($requestData);
            //die();

            try {

                $device = $this->managerRegistry->getRepository(Device::class)->findOneBy(['id' => $deviceId]);

                if($smsTemplateId !== self::ARBITRARY_SMS_ID){
                    $smsTemplate = $this->managerRegistry->getRepository(SmsTemplate::class)->findOneBy(['id' => $smsTemplateId]);
                    $smsText = $smsTemplate->getLabel();
                }else{
                    $smsText = $customSmsText;
                }

                if($destinationType === 'Device'){
                    $simCard = $this->managerRegistry->getRepository(SimCard::class)->findOneBy(['id' => $smsSimcardId]);
                    if($simCard)
                        $msisdn = $simCard->getMsisdn();
                }else {
                    $msisdn = $msisdnText;
                }

                $isLinkableDeviceNetDevs = $device->getNetDevices()->filter(function (DeviceNetDev $entry) {
                    return ($entry->getIsLinkable() === true);
                });

                if(count($isLinkableDeviceNetDevs) !== 1){
                    throw new \Exception('More than one net devs are set as linkable.');
                }

                $netDev = $isLinkableDeviceNetDevs->first();

                try{

                    $apiService->sendSms($deviceId, $msisdn, $netDev->getId(), $smsText);

                }catch (\Exception $e){

                    $this->addFlash(
                        'danger',
                        'Sms cannot be send. ' . $e->getMessage(),
                    );

                    return $this->redirectToRoute('admin_tool_sms_sender_index');

                }

                $smsHistory = new SmsHistory();

                $smsHistory->setDevice($device);
                if($smsTemplateId !== self::ARBITRARY_SMS_ID) {
                    $smsHistory->setSmsTemplate($smsTemplate);
                }else{
                    $smsHistory->setCustomText($smsText);
                }
                $smsHistory->setDestination($msisdn);

                $em->persist($smsHistory);
                $em->flush();

                $this->addFlash(
                    'success',
                    'Sms sent successfully.',
                );

            } catch (\Exception $e) {
                $this->addFlash(
                    'danger',
                    $e->getMessage(),
                );
            }

            return $this->redirectToRoute('admin_tool_sms_sender_index');
        }

        return $this->render('tool/smsSender/send.html.twig', [
            'simCardForm' => $form->createView()
        ]);

    }

}
