<?php

declare(strict_types=1);

namespace App\Entity\Snmp;

use App\Repository\SnmpDeviceRepository;
use DateTime;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'snmp_devices')]
#[ORM\Entity(repositoryClass: SnmpDeviceRepository::class)]
class Device
{

    final public const ENTITY_TABLE_NAME = 'snmp_devices';

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 128, unique: true, nullable: true)]
    public ?string $address = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: true)]
    public ?string $communityString = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER, nullable: true, options: ['default' => 2])]
    public ?int $protocolVersion = 2;

    /**
     * @var DateTime|null
     */
    #[ORM\Column(type: Types::DATETIME_IMMUTABLE, nullable: true, options: ['default' => null])]
    public ?DateTime $lastSuccess = null;

    /**
     * @var DateTime|null
     */
    #[ORM\Column(type: Types::DATETIME_IMMUTABLE,  nullable: true, options: ['default' => null])]
    public ?DateTime $lastFailure = null;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true, options: ['default' => 0])]
    public ?int $errorsSinceSuccess = 0;

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER, length: 5, nullable: true, options: ['default' => null])]
    public ?int $registeredAs = null;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'registered_as_devid', type: Types::STRING, length: 32, nullable: true, options: ['default' => null])]
    public ?string $registeredAsDevId = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 32, nullable: true, options: ['default' => null])]
    public ?string $devtokenAgCopy = null;


    /**
     * Label constructor
     */
    public function __construct() {

    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return string|null
     */
    public function getAddress(): ?string
    {
        return $this->address;
    }

    /**
     * @param string|null $address
     */
    public function setAddress(?string $address): void
    {
        $this->address = $address;
    }

    /**
     * @return string|null
     */
    public function getCommunityString(): ?string
    {
        return $this->communityString;
    }

    /**
     * @param string|null $communityString
     */
    public function setCommunityString(?string $communityString): void
    {
        $this->communityString = $communityString;
    }

    /**
     * @return int|null
     */
    public function getProtocolVersion(): ?int
    {
        return $this->protocolVersion;
    }

    /**
     * @param int|null $protocolVersion
     */
    public function setProtocolVersion(?int $protocolVersion): void
    {
        $this->protocolVersion = $protocolVersion;
    }

    /**
     * @return DateTime|null
     */
    public function getLastSuccess(): ?DateTime
    {
        return $this->lastSuccess;
    }

    /**
     * @return DateTime|null
     */
    public function getLastFailure(): ?DateTime
    {
        return $this->lastFailure;
    }

    /**
     * @return int|null
     */
    public function getErrorsSinceSuccess(): ?int
    {
        return $this->errorsSinceSuccess;
    }

    /**
     * @return int|null
     */
    public function getRegisteredAs(): ?int
    {
        return $this->registeredAs;
    }

    /**
     * @return string|null
     */
    public function getRegisteredAsDevId(): ?string
    {
        return $this->registeredAsDevId;
    }

    /**
     * @return string|null
     */
    public function getDevTokenAgCopy(): ?string
    {
        return $this->devtokenAgCopy;
    }

}