#!/bin/bash

RETCODE=0

BASEDEFS="base_defs"
FUNCS="deploy_funcs.sh"
MYSQOPT=${MYSQOPT:-}
INITKEYS=${INITKEYS:-}
export MYSQOPT

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

. "$DIR/$BASEDEFS" || { RETCODE=2; ERRMSG="eURL update: Fatal: Definition file ($DIR/$BASEDEFS) not found."; exit 1; }
. "$DIR/$FUNCS" || { RETCODE=2; ERRMSG="eURL update: Fatal: Deploy functions ($DIR/$FUNCS) not found."; exit 1; }

read_defs "$ORIG_DEPLOY_STR" || { RETCODE=2; ERRMSG="eURL update: Fatal: Cannot run read_defs()."; exit 1; }

if [[ -z "$MYSQOPT" && -n "$DBPASS" ]] ; then
	MYSQOPT="-p$DBPASS"
fi

MYTMPDIR="/tmp/${SHORTNAME}_ipax.$$/"
ACTDIR="tmp"
MYOLDDIR=$(pwd)
ERRMSG=""
MESSAGE=""
KEYS_DONE=""

tidy_up() {
	cd "$MYOLDDIR"
	rm -rf "$MYTMPDIR" 2>/dev/null
}

trap tidy_up EXIT

validate_deploy_commands || { RETCODE=1; ERRMSG="eURL update: Unable to validate commands"; exit ; }

MYOPWD=$(pwd)

$C_SYSTEMCTL is-active ${DWARFG_NAM}.service >/dev/null
g_app_active=$?
[ 0 -eq "$g_app_active" ] && echo "Stopping $SHORTNAME ..." && $C_SYSTEMCTL stop ${DWARFG_NAM}.service
if [ "$RETCODE" -eq 0 ] ; then
	[[ -n "$INITKEYS" && "$USE_SSL" -gt 0 && "$UPGRADING" -eq 0 ]] && {
		KEYS_DONE="yes"
		if [ -n "$1" ] ; then 
			CERTDOMAIN="$1" "$BINDIR/gencerts.sh" || { RETCODE=2; ERRMSG="eURL update: Error during generating certificate"; KEYS_DONE=""; }
		else
			"$BINDIR/gencerts.sh" || { RETCODE=2; ERRMSG="eURL update: Error during generating certificate"; KEYS_DONE=""; }
		fi
	}
	g_serv_mindate="$(date "+%F")"
	while true; do
		if [[ $# -eq 1  && "$1" != "-h" && "$1" != "--help" ]] ; then
			if [[ "$EXTERNURL" = "$1" && "$UPGRADING" -eq 0 ]] ; then
				MESSAGE="$NAME external URL unchanged."
				break
			else
				echo "EXTERNURL/1 $EXTERNURL/$1"
				mkdir $MYTMPDIR || { RETCODE=1; ERRMSG="eURL update: Unable to create tmp directory $MYTMPDIR"; break; }
				cd $MYTMPDIR || { RETCODE=1; ERRMSG="eURL update: Unable to chdir to $MYTMPDIR"; break; }
				echo "Updating DEF_SERVER to $1..."
				update_externurl "$1" || { RETCODE=1; ERRMSG="eURL update: Unable to update EXTERNURL in $BASEDEFS"; break; }
				$C_MYSQL $MYSQOPT "$DWARFG_DBN"<<EOF
UPDATE product_conf SET strval="$1" WHERE name="ExternalURL";
EOF
				cd $BINDIR
				if [[ -z "$KEYS_DONE" && "$USE_SSL" -gt 0 && "$UPGRADING" -eq 0 ]] ; then
					CERTDOMAIN="$1" "$BINDIR/gencerts.sh" || { RETCODE=2; ERRMSG="eURL update: Error during re-generating certificate when updating external URL but URL updated already."; break; }
				fi
				for i in "$BINDIR/agents"/*/*tgz; do
					echo "Updating package $i:"
					mkdir $ACTDIR || { RETCODE=3; ERRMSG="eURL update: Agent repack: Unable to create $ACTDIR"; break 2; }
					cd $ACTDIR || { RETCODE=3; ERRMSG="eURL update: Agent repack: Unable to chdir to $ACTDIR"; break 2; }
					tar xzf "$i";
					find . -name "${SHORTNAME}_agent.sh" -type f -print0 | while IFS= read -r -d '' file; do
						FULLFILE="$(pwd)/$file"
						echo -e "\tupdating file $FULLFILE..."
						sed -i --follow-symlinks "0,/g_ctxt_defserv=.*/s/g_ctxt_defserv=.*/g_ctxt_defserv=$1/" "$file"
						sed -i --follow-symlinks "0,/g_servid=.*/s/g_servid=.*/g_servid=\"$SERVID\"/" "$file"
						sed -i --follow-symlinks "0,/g_fix_mindate=.*/s/g_fix_mindate=.*/g_fix_mindate=\"$g_serv_mindate\"/" "$file"
					done
					if [ -d "./$(basename ${i//.tgz})" ] ; then
						cp "$BINDIR/ssl/server.pem" "./$(basename ${i//.tgz})/" 2>/dev/null
					elif [ -d "./a${SHORTNAME}" ] ; then
						cp "$BINDIR/ssl/server.pem" "./a${SHORTNAME}/" 2>/dev/null
					else
						RETCODE=5
						ERRMSG="eURL update: Agent \"$i\" repack problem: unable to locate dir to put server certificate to (no ./$(basename ${i//.tgz}) neither ./a${SHORTNAME} dirs there)"
						break
					fi
					tar --numeric-owner --group=0 --owner=0 -czf "$i" ./*;
					cd .. && rm -r "$ACTDIR"
				done
				for i in "$BINDIR/agents"/*/*ipk; do
					echo "Updating package $i:"
					mkdir $ACTDIR || { RETCODE=3; ERRMSG="eURL update: IPK repack ($i): Unable to create $ACTDIR"; break 2; }
					cd $ACTDIR || { RETCODE=3; ERRMSG="eURL update: IPK repack ($i): Unable to cd $ACTDIR"; break 2; }
					{ tar xzf "$i" && mkdir data control && pushd data >/dev/null && tar xzf ../data.tar.gz && { [ ! -f "$BINDIR/ssl/server.pem" ] || cp "$BINDIR/ssl/server.pem" opt/a${SHORTNAME}/; } && rm ../data.tar.gz && tar --numeric-owner --group=0 --owner=0 -czf ../data.tar.gz ./*; } || { RETCODE=3; ERRMSG="eURL update: IPK repack ($i): Unable to update server certificate in data package"; break 2; }
					{ popd >/dev/null && pushd control >/dev/null && tar xzf ../control.tar.gz && FULLFILE="$(pwd)/postinst" && echo -e "\tupdating file $FULLFILE..." ; } || { RETCODE=3; ERRMSG="eURL update: IPK repack ($i): Unable to unpack control part"; break 2; }
					sed -i --follow-symlinks "0,/g_ctxt_defserv=.*/s/g_ctxt_defserv=.*/g_ctxt_defserv=$1/" "postinst"
					sed -i --follow-symlinks "0,/g_servid=.*/s/g_servid=.*/g_servid=\"$SERVID\"/" "postinst"
					{ rm ../control.tar.gz && tar --numeric-owner --group=0 --owner=0 -czf ../control.tar.gz ./* ; } || { RETCODE=3; ERRMSG="eURL update: IPK repack ($i): Unable to create control part."; break 2; }
					{ popd >/dev/null && tar --numeric-owner --group=0 --owner=0 -czf "$i" ./control.tar.gz ./data.tar.gz ./debian-binary; } || { RETCODE=3; ERRMSG="eURL update: IPK repack ($i): Unable to finish package."; break 2; }
					{ cd .. && rm -r "$ACTDIR"; } || { RETCODE=3; ERRMSG="eURL update: IPK repack ($i): Unable to cleanup"; break 2; }
				done
				sudo $C_SYSTEMCTL reload apache2.service || { RETCODE=4; ERRMSG="eURL update: URL updated but failed to reload apache configuration."; break; }
				MESSAGE="Server IP address was updated in agent archive to $1."
				break
			fi
		else
			echo -e "\n$NAME script to update agent's packages server URL/IP address.\n"
			exit 1
		fi
	done
fi
[ 0 -eq "$g_app_active" ] && echo "Starting $SHORTNAME ..." && $C_SYSTEMCTL start ${DWARFG_NAM}.service

cd "$MYOPWD"

case $RETCODE in
	0)
		[ -n "$MESSAGE" ] && echo "$MESSAGE"
		event_log 304 MSG="$MESSAGE"
		exit 0
		;;
	1|3|4)
		event_log 301 MSG="$ERRMSG"
		echo "$ERRMSG" >&2
		exit 1
		;;
	2)
		event_log 302 MSG="$ERRMSG"
		echo "$ERRMSG" >&2
		exit 1
		;;
	*)
		event_log 302 MSG="Unknown error: $ERRMSG"
		echo "$ERRMSG" >&2
		exit 1
		;;
esac

