<?php

namespace App\Datatables\Column;

use Sg\DatatablesBundle\Datatable\Column\Column;

class CustomArrayColumn extends Column
{
    /**
     * {@inheritdoc}
     */
    public function renderSingleField(array &$row)
    {
        $row[$this->data] = $this->arrayToString($row[$this->data] ?? []);

        return parent::renderSingleField($row);
    }

    /**
     * @param int $tab
     */
    protected function arrayToString( $array, $tab = 0): string
    {
        if(!is_array($array)){

            $array = explode(',', $array);
        }

        $arrayField = '';
        $isArrayAssociative = $this->isAssociative($array);
        foreach ($array as $key => $arrayElement) {
            for ($i = 0; $i < $tab; ++$i) {
                $arrayField .= '&nbsp&nbsp';
            }

            if ($isArrayAssociative) {
                $arrayField .= $key.': ';
            }

            if (\is_array($arrayElement)) {
                $arrayField .= '[<br/>';
                $arrayField .= $this->arrayToString($arrayElement, $tab + 1);
                $arrayField .= ']<br/>';

                continue;
            }

            if ($arrayElement instanceof \DateTime) {
                $arrayField .= $arrayElement->format('Y-m-d').'<br/>';

                continue;
            }

            $arrayField .= '<span class="badge badge-success" style="margin-right: 3px;">' . $arrayElement.'</span>';
        }

        return $arrayField;
    }

    protected function isAssociative(array $array): bool
    {
        if (empty($array)) {
            return false;
        }

        return array_keys($array) !== range(0, \count($array) - 1);
    }
}
