<?php

namespace App\ValueObject;

use InvalidArgumentException;

final class Configuration
{

    public const CONFIG_PRODUCT_ROOT_DIR = 'ProductRootDir';
    public const CONFIG_SERVER_IP_ADDRESS = 'ExternalURL';
    public const CONFIG_SERVER_LOCAL_PORT = 'LocalPort';
    public const CONFIG_IS_FIRST_RUN = 'isFirstRun';
    public const CONFIG_SAAS_MODE = 'SAASMode';
    public const CONFIG_SUPPORT_LINK = 'SupportLink';
    public const CONFIG_ENABLED_EMAIL_NOTIFICATIONS = 'EnabledEmailNotifications';
    public const CONFIG_ENABLED_EMAIL_NOTIFICATION_TO_ADDRESS = 'EnableEmailNotificationToAddress';
    public const CONFIG_NOTIFICATION_EMAIL = 'NotificationEmail';
    public const CONFIG_SENDER_EMAIL = 'SenderEmail';
    public const CONFIG_SMTP_SERVER = 'SmtpServer';
    public const CONFIG_SMTP_PORT = 'SmtpPort';
    public const CONFIG_SMTP_SECURITY = 'SmtpSecurity';
    public const CONFIG_SMTP_LOGIN = 'SmtpLogin';
    public const CONFIG_SMTP_PASSWORD = 'SmtpPassword';
    public const CONFIG_SLACK_TOKEN = 'SlackToken';
    public const CONFIG_SLACK_CHANNEL = 'SlackChannel';
    public const CONFIG_SLACK_BOT_NAME = 'SlackBotName';
    public const CONFIG_LICENSE = 'MamasLicDump';
    public const CONFIG_SYSCTLPATH_COMMAND = 'SysctlPath';
    public const CONFIG_SERVICE_CORE_NAME = 'ServiceCoreName';
    public const CONFIG_WEB_TUNNEL_URL = 'WebTunnelURL';
    public const CONFIG_AGGREGATED_LOGS_FILE_NAME = 'AggregatedLogsFile';
    public const CONFIG_DEVICE_TABLE_COLUMNS= 'DevicesTableColumns';

    private string $value;

    private function __construct(string $value) {

        $this->setValue($value);

    }

    public static function fromString(string $value): self {

        return new self($value);

    }

    /**
     */
    public static function ipAddress(): self {

        return new self(self::CONFIG_SERVER_IP_ADDRESS);

    }

    public function getValue(): string {

        return $this->value;

    }

    public function isIpAddress(): bool {

        return $this->value === self::CONFIG_SERVER_IP_ADDRESS;

    }

    /**
     * @return string[]
     */
    public static function getPossibleValues(): array {

        return [
            self::CONFIG_PRODUCT_ROOT_DIR, self::CONFIG_SERVER_IP_ADDRESS, self::CONFIG_SERVER_LOCAL_PORT,
            self::CONFIG_IS_FIRST_RUN, self::CONFIG_SAAS_MODE, self::CONFIG_SUPPORT_LINK,
            self::CONFIG_ENABLED_EMAIL_NOTIFICATIONS, self::CONFIG_ENABLED_EMAIL_NOTIFICATION_TO_ADDRESS,
            self::CONFIG_NOTIFICATION_EMAIL, self::CONFIG_SENDER_EMAIL,
            self::CONFIG_SMTP_SERVER, self::CONFIG_SMTP_PORT, self::CONFIG_SMTP_SECURITY, self::CONFIG_SMTP_LOGIN,
            self::CONFIG_SMTP_PASSWORD, self::CONFIG_SLACK_TOKEN,
            self::CONFIG_SLACK_CHANNEL, self::CONFIG_SLACK_BOT_NAME,
            self::CONFIG_LICENSE, self::CONFIG_SYSCTLPATH_COMMAND, self::CONFIG_SERVICE_CORE_NAME,
            self::CONFIG_WEB_TUNNEL_URL, self::CONFIG_AGGREGATED_LOGS_FILE_NAME, self::CONFIG_DEVICE_TABLE_COLUMNS,
        ];

    }

    /**
     * @param string $value
     * @return $this
     */
    private function setValue(string $value): self {

        if (!in_array($value, self::getPossibleValues())) {

            throw new InvalidArgumentException('Invalid value "'. $value .'" given for ' . self::class);
            
        }

        $this->value = $value;

        return $this;

    }

    public function __toString(): string {

        return $this->value;

    }

}