#!/bin/bash

FUNCS="deploy_funcs.sh"
DWARFG_DEFS="base_defs"

command -v dirname >/dev/null 2>&1 || {
	echo "\"dirname\" command not available, bailing out." >&2
	exit 1
}

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

[ $# -eq 1 ] || {
	echo "You must provide BINDIR (e.g. /opt/${SHORTNAME}_your_domain) as first parameter" >&2
	exit 1
}

. "$1/$DWARFG_DEFS" || {
	echo "Unable to source deployed $NAME deps file ($1/$DWARFG_DEFS)" >&2
	exit 1
}

. "$1"/"$FUNCS" || {
	echo "Unable to read deploy functions, exiting..." >&2
	exit 1
}

read_defs "$ORIG_DEPLOY_STR" || fail_fat "Unable to read all required definitions."

validate_deploy_commands || fail_fat "Some of the required commands are missing."


ERR=0
USE_SSL=${USE_SSL:-1}
export USE_SSL
ADMNAME=${ADMNAME:-admin@localhost}
ADMPWD=${ADMPWD:-defaultPWDplsCHANGEme}
OPERNAME=${OPERNAME:-operator@localhost}
OPERPWD=${OPERPWD:-defaultOPERATORpwd}
APACONF_INST=$DWARFG_APACONF_INST
[ "$USE_SSL" -eq 0 ] && APACONF_INST=$DWARFG_APACONF_INST_NOSSL

MYID=$($C_ID -u)
MYSCDKEY=""
[ 0 -ne "$MYID" ] && fail_fat "$NAME application init script must run as root."
$C_CHOWN "$APPUSER" "$SRVDIR_SRV" || fail_fat "Failed to change ownership of directory \"$SRVDIR_SRV\" to user \"$APPUSER\""
MYOXPWD=$(pwd)
[ 0 -eq "$UPGRADING" ] && {
	prep_servid || fail_fat "Unable to generate ServerID"
	MYSCDKEY=$(prep_scdkey)
	[ $? -eq 0 ] || fail_fat "Unable to generate SCDKEY"
}
cd "$BINDIR" || fail_fat "Cannot change directory to $BINDIR"
[ 0 -eq "$UPGRADING" ] && {
	prep_db || fail_fat "Unable to create database ($DWARFG_DBN) or user."
}
CNTR=5
if [ 0 -eq "$UPGRADING" ] ; then
	echo "Populating $NAME database..."
	$C_MYSQL $MYSQOPT "$DWARFG_DBN" < "$BINDIR/db_init_scheme.sql" || fail_fat "Not able to initialize $NAME database scheme (1/$CNTR)."
	$C_MYSQL $MYSQOPT "$DWARFG_DBN" < "$BINDIR/db_init_basedata.sql" || fail_fat "Not able to initialize $NAME database base data (2/$CNTR)."
	# handle also all upgrade scripts...
	$C_MYSQL $MYSQOPT "$DWARFG_DBN" < "$BINDIR/db_init_verdata.sql" || fail_fat "Not able to initialize $NAME database version data (3/$CNTR)."
	$C_MYSQL $MYSQOPT "$DWARFG_DBN" < "$BINDIR/db_init_guidata.sql" || fail_fat "Not able to initialize $NAME database gui data (4/$CNTR)."
	$C_MYSQL $MYSQOPT "$DWARFG_DBN" < "$BINDIR/db_init_default_alerts.sql" || fail_fat "Not able to initialize $NAME database default alerts (5/$CNTR)"
else
	CNTR=2
fi
if [ -n "$DOMAIN" ] ; then
	CERTDOMAIN="$DOMAIN"
	export CERTDOMAIN
fi
if [[ -z "$CERTDOMAIN" && -n "$EXTERNURL" ]] ; then
	CERTDOMAIN="$EXTERNURL"
	export CERTDOMAIN
fi
[ 0 -eq "$UPGRADING" ] && {
	if [ -n "$CERTDOMAIN" ] ; then
		$C_MYSQL $MYSQOPT "$DWARFG_DBN"<<EOF
UPDATE product_conf SET strval="$CERTDOMAIN" WHERE name='ExternalURL';
EOF
	echo "Storing bindir/srvdir in DB..."
	$C_MYSQL $MYSQOPT "$DWARFG_DBN"<<EOF
UPDATE product_conf SET strval="$BINDIR" WHERE name='ProductRootDir';
EOF
	$C_MYSQL $MYSQOPT "$DWARFG_DBN"<<EOF
UPDATE product_conf SET strval="$SRVDIR" WHERE name='ProductSrvDir';
EOF
	fi
	if [ -d ssl ] ; then
		echo "ssl directory found, skipping generating of certificates"
	else
		if [ "$USE_SSL" -ne 0 ] ; then
			$C_MKDIR ssl || fail_fat "Unable to create SSL directory"
			$C_LN -s ../server.pem ssl/ || fail_fat "Cannot link certificate file."
			$C_LN -s ../server.key ssl/ || fail_fat "Cannot link cert-key file"
		fi
	fi
}
INITKEYS="yes please" ./exchange_server_ip.sh "$CERTDOMAIN" || fail_fat "Failed to re-package agent files with server certificate."
# prepare log rotation stuff
$C_SED -i --follow-symlinks "s#DWARFG_SRVDIR#$SRVDIR#" "$BINDIR/${SHORTNAME}_logrotate.conf"
$C_SED -i --follow-symlinks "s#DWARFG_BINDIR#$BINDIR#" "$BINDIR/${SHORTNAME}_logrotate.conf"
$C_LN -s "$BINDIR/${SHORTNAME}_logrotate.conf" "/etc/logrotate.d/${DWARFG_DBN}_logrotate.conf"
cd "$MYOXPWD" || fail_fat "Cannot change directory to $MYOXPWD"
$C_CHOWN -R "$WWWUSER" "$SRVDIR/var" || fail_fat "Unable to change ownership of $SRVDIR/var to $WWWUSER"
"$C_CHMOD" ug+w "$FWUPLOADDIR" || fail_fat "Unable to set permissions for $FWUPLOADDIR"
"$C_CHGRP" "$APPGROUP" "$FWUPLOADDIR" || fail_fat "Unable to change group owner on $FWUPLOADDIR"
$C_CHOWN -R "$WWWUSER" "$BINDIR/web/customized_agents" || fail_fat "Unable to change ownership of $BINDIR/web/customized_agents to $WWWUSER"
$C_LN -s "$SRVDIR/var" "$GUIDIR/var" || fail_fat "Unable to link back application var directory"
$C_CP "$GUIDIR/.env.dist" "$GUIDIR/.env" || fail_fat "Unable to copy GUI dist file"
$C_SED -i --follow-symlinks 's/^\(APP_ENV\)=.*/\1=prod/' "$GUIDIR/.env" || fail_fat "Unable to set APP_ENV in GUI dist file."
$C_SED -i --follow-symlinks "s/^\(DATABASE_URL=mysql:\/\/\\)db_user:db_password@\([0-9.]*\):\([0-9]*\)\/db_name/\1$APPUSER:$DBPASS@\2:\3\/$DWARFG_DBN/" "$GUIDIR/.env" || fail_fat "Unable to set DATABASE_URL in GUI dist file."
$C_SED -i --follow-symlinks "s/^\(DWARFG_UI_SCDKEY=\).*/\1'$MYSCDKEY'/" "$GUIDIR/.env" || fail_fat "Unable to set SCDKEY in GUI dist file."
$C_CP "$NOTIFYDIR/.env.dist" "$NOTIFYDIR/.env" || fail_fat "Unable to copy NOTIFY dist file"
$C_SED -i --follow-symlinks 's/^\(APP_ENV\)=.*/\1=prod/' "$NOTIFYDIR/.env" || fail_fat "Unable to set APP_ENV in NOTIFY dist file."
$C_SED -i --follow-symlinks "s/^\(DATABASE_URL=mysql:\/\/\\)db_user:db_password@\([0-9.]*\):\([0-9]*\)\/db_name/\1$APPUSER:$DBPASS@\2:\3\/$DWARFG_DBN/" "$NOTIFYDIR/.env" || fail_fat "Unable to set DATABASE_URL in NOTIFY dist file."
$C_A2ENMOD ssl || fail_fat "Cannot enable Apache2 ssl module" # enable ssl always due to webtunnel...
$C_A2ENMOD rewrite || fail_fat "Cannot enable Apache2 rewrite module"
$C_A2ENMOD proxy || fail_fat "Cannot enable Apache2 proxy module"
$C_A2ENMOD proxy_http || fail_fat "Cannot enable Apache2 proxy_http module"
$C_A2ENMOD proxy_connect || fail_fat "Cannot enable Apache2 proxy_connect module"
# process Dwarfg apache config with domain and copy if not one present already
echo "Generating new $NAME apache config (using $DOMAIN/$DWARFG_PORT from $BINDIR/$APACONF_INST to $BINDIR/$DWARFG_APACONF)"
subst_domain="$DOMAIN"
[ -z "$subst_domain" ] && subst_domain="localhost"
$C_CAT "$BINDIR/$APACONF_INST" | $C_SED "s/DWARFG_DOMAIN/$subst_domain/g" | $C_SED "s/DWARFG_PORT/$DWARFG_PORT/" >"$BINDIR/$DWARFG_APACONF"
apa_servsite || fail_fat "Unable to prepare apache2 $NAME site."
enable_ffi || fail_fat "Unable to enable FFI for PHP. Contact support or setup manually and restart install process."
set_phpini_var "max_input_vars" "20000" || fail_fat "Unable to configure max_input_vars in php.ini."
set_phpini_var "upload_max_filesize" "40M" || fail_fat "Unable to configure upload_max_filesize in php.ini."
set_phpini_var "post_max_size" "41M" || fail_fat "Unable to configure post_max_size in php.ini."
if [ 0 -eq "$UPGRADING" ] ; then
	echo "UPDATE product_conf set strval=\"$C_SYSTEMCTL\" where name='SysctlPath';" | $C_MYSQL $MYSQOPT "$DWARFG_DBN" || fail_nof "Warning: unable to update systemctl path. If default path does not fit, restarting $NAME service from GUI will not work."
	update_sysctl "$C_SYSTEMCTL"
fi
MYPWD=$(pwd)
$C_MKDIR -m 777 -p "$WEBVARDIR/cache"
cd "$GUIDIR"
[ 0 -eq "$UPGRADING" ] && {
	$C_SUDO -u "$WWWUSER" "$C_PHP" bin/console user:create "$ADMNAME" "$ADMPWD" ROLE_SUPER_ADMIN || fail_fat "Unable to add admin user to GUI"
	$C_SUDO -u "$WWWUSER" "$C_PHP" bin/console user:create "$OPERNAME" "$OPERPWD" ROLE_ADMIN -a false || fail_fat "Unable to add operator user to GUI"
}
$C_RM -rf "$WEBVARDIR/cache"
$C_CHGRP -R "$WMGROUP" "$SRVDIR_SRV" || fail_fat "Failed to change group ownership of dir $SRVDIR_SRV to group $WMGROUP"
$C_CHMOD -R g+ws "$SRVDIR_SRV" || fail_fat "Failed to set permissions for directory $SRVDIR_SRV"
$C_MKDIR -p "$GUIDIR/public/upload" || fail_fat "Failed to create GUI upload directory $GUIDIR/public/upload"
$C_CHOWN -R "$WWWUSER" "$GUIDIR/public/upload" || fail_fat "Unable to change ownership of $GUIDIR/public/upload to $WWWUSER"
$APACHE_RELOAD || fail_nof "Unable to reload apache - manual reload/restart is needed!"
update_cmdline
integrate_cmdline
echo "Creating InfluxDB database $DWARFG_DBN ..."
if $C_SED -i "s/DWARFG_DBN/$DWARFG_DBN/g" "$BINDIR/influx_db.txt"; then
	influx -import -path="$BINDIR/influx_db.txt" -precision=s || echo "Failed to create DB in InfluxDB. Reinstall to retry." >&2
else
	echo "InfluxDB preparation failed. Reinstall to retry." >&2
fi
cd "$MYPWD"
