#!/bin/bash

BASEDEFS="base_defs"

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

. "$DIR"/"$BASEDEFS" || { echo "Fatal: Definition file ($BASEDEFS) not found."; exit 1; }
. "$DIR"/"$BASEFUNCS" || { echo "Fatal: Basic functions ($BASEFUNCS) not found."; exit 1; }
[ -f "$DWARFG_SITECONF" ] && . "$DWARFG_SITECONF"

if [ -n "$DBPASS" ] ; then
	mysql "$DWARFG_DBN" --password="$DBPASS" -Nse "SELECT COUNT(*) FROM devices WHERE deleted = FALSE;"
else
	mysql "$DWARFG_DBN" -Nse "SELECT COUNT(*) FROM devices WHERE deleted = FALSE;"
fi
