<?php

declare(strict_types=1);

namespace App\Entity\Types;

use App\Entity\Device;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'liveness_time')]
#[ORM\Entity]
class LivenessTime
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: false)]
    public string $description;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: Device\DeviceStats::class, mappedBy: 'liveTime', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $devicesStats;

    /**
     * LivenessTime constructor
     */
    public function __construct(){

        $this->devicesStats = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getDescription(): string {

        return $this->description;

    }

}