<?php

namespace App\Form\ConfigProfile;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ConfigProfileFromDeviceType extends AbstractType
{

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
	{

        $builder
            ->add('label', TextType::class, [
				'required' => false,
				'block_prefix' => 'modal_body',
			])
			->add('device', ChoiceType::class, [
				//'label' => 'Set from the device',
				'label' => false,
				'required' => true,
				'choices' => null, //$devicesChoices,
				//'choice_attr' => $deviceChoicesAttr,
				//'placeholder' => 'Select a Device',
				'data' => $options['data']['device'] ?? null,
				'mapped' => false,
				'auto_initialize' => false,
				'attr' => ['data-row-class' => 'device'], //Important to setup to send data from the form
				'block_prefix' => 'modal_body',

				//'help' => '<p style="padding-left: 10px;">You can select all devices with system label <b>Sms</b> and assigned <b>Authentication profile</b>, selected Linkable network device with IP.</b></p>
               //             <p style="padding-left: 10px;">Device must have only one <b>Network device</b> set as <b>Linkable</b>, see the device detail to set it up.</p>',
				//'help_html' => true,
			])
            ->add('save', SubmitType::class, ['label' => 'Create Config Profile',
                'block_prefix' => 'modal_footer'])
        ;
    }

    /**
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver): void
	{

        $resolver->setDefaults([
           // 'data_class' => OsVersion::class,
        ]);

    }

}