<?php

namespace App\Form\Settings;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\FormType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

final class DclSettingsType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
	{

        $configFormData = $options['data']['configFormData'];

        if (!empty($configFormData)) {
            $builder->add(
                $builder->create('config', FormType::class, ['inherit_data' => true]),
            );
            $groupBuilder = $builder->get('config');
            foreach ($configFormData as $configFormItem) {

				$groupBuilder->add($configFormItem->getId() . '_logStream', CheckboxType::class, [
					'label' => $configFormItem->name,
					'label_attr' => ['class' => 'switch-custom'],
					'required' => false,
					'data' => $configFormItem->isLogStream(),
					'value' => true,
				]);

				$groupBuilder->add($configFormItem->getId() . '_logDb', CheckboxType::class, [
					'label' => $configFormItem->name,
					'label_attr' => ['class' => 'switch-custom'],
					'required' => false,
					'data' => $configFormItem->isLogDb(),
					'value' => true,
				]);

				$groupBuilder->add($configFormItem->getId() . '_logFile', CheckboxType::class, [
					'label' => $configFormItem->name,
					'label_attr' => ['class' => 'switch-custom'],
					'required' => false,
					'data' => $configFormItem->isLogFile(),
					'value' => true,
				]);

				// dump($configFormItem);
            }
        }

        $builder->add('save', SubmitType::class, ['label' => '<i class="fa-solid fa-floppy-disk" aria-hidden="true"></i> Save', 'label_html' => true]);

    }

}
