<?php declare(strict_types=1);

namespace App\Service;

use App\DataTable\AlertDatatable;
use App\DataTable\DeviceDatatable;
use App\Entity\AgentProfile\AgentProfile;
use App\Entity\Alert\AlertTargetSpec;
use App\Entity\Alert\AlertTargetType;
use App\Entity\Device\Device;
use App\Entity\Device\DeviceModel;
use App\Entity\Device\DeviceOsType;
use App\Entity\Device\DeviceOsVersion;
use App\Entity\Device\DeviceSyncStatus;
use App\Entity\Device\DeviceType;
use App\Entity\Label\Label;
use App\Entity\Label\SystemLabel;
use App\Entity\MonitoringGroup\MonitoringGroup;
use App\Entity\Tool\AuthProfile;
use App\Entity\Tool\SimCard;
use App\Entity\Types\LivenessMisscount;
use App\Repository\DeviceRepository;
use Doctrine\Persistence\ManagerRegistry;
use Sg\DatatablesBundle\Datatable\DatatableFactory;
use Sg\DatatablesBundle\Datatable\DatatableInterface;

class DatatableService
{

    private DatatableFactory $datatableFactory;

    private ManagerRegistry $managerRegistry;

    private ConfigurationService $configurationService;
	private DeviceRepository $deviceRepository;

	/**
     * @param DatatableFactory $datatableFactory
     * @param ManagerRegistry $managerRegistry
     * @param ConfigurationService $configurationService
     */
    public function __construct(DatatableFactory $datatableFactory, ManagerRegistry $managerRegistry,
                                ConfigurationService $configurationService, DeviceRepository $deviceRepository){

        $this->datatableFactory = $datatableFactory;
        $this->managerRegistry = $managerRegistry;
        $this->configurationService = $configurationService;
		$this->deviceRepository = $deviceRepository;

    }

    /**
     * @param string $class
     * @param array $data
     * @return DatatableInterface
     * @throws \Exception
     */
    public function getDeviceDatatable(string $class = DeviceDatatable::class, array $data = []): DatatableInterface {

        $deviceSyncStatuses = $this->managerRegistry->getRepository(DeviceSyncStatus::class)->findAll();
        $deviceFreshness = $this->managerRegistry->getRepository(LivenessMisscount::class)->findAll();
        $deviceTypes = $this->managerRegistry->getRepository(DeviceType::class)->findAll();
        $deviceOsType = $this->managerRegistry->getRepository(DeviceOsType::class)->findAll();
        //$osVersions = $this->managerRegistry->getRepository(DeviceOsVersion::class)->findBy(['available' => 1]);
		$osVersions = $this->deviceRepository->getDevicesFwVersions();
        $deviceLabels = $this->managerRegistry->getRepository(Label::class)->findAll();
        $deviceSystemLabels = $this->managerRegistry->getRepository(SystemLabel::class)->findAll();
        $deviceSimCards = $this->managerRegistry->getRepository(SimCard::class)->findAll();
        $deviceMonitoringGroups = $this->managerRegistry->getRepository(MonitoringGroup::class)->findAll();
        $deviceAgentProfiles = $this->managerRegistry->getRepository(AgentProfile::class)->findAll();
        $deviceAuthProfiles = $this->managerRegistry->getRepository(AuthProfile::class)->findAll();
        $deviceModels = $this->managerRegistry->getRepository(DeviceModel::class)->findAll();
        $devices = $this->managerRegistry->getRepository(Device::class)->getDevices();
        $deviceTableColumns = $this->configurationService->getDeviceTableColumns();

        $data = array_merge($data, ['devices' => $devices, 'syncStatuses' => $deviceSyncStatuses,
            'freshnessStatuses' => $deviceFreshness, 'deviceTypes' => $deviceTypes,
            'osTypes' => $deviceOsType, 'osVersions' => $osVersions, 'deviceLabels' => $deviceLabels,
            'deviceSystemLabels' => $deviceSystemLabels, 'deviceSimCards' => $deviceSimCards,
            'deviceMonitoringGroups' => $deviceMonitoringGroups,
            'agentProfiles' => $deviceAgentProfiles, 'authProfiles' => $deviceAuthProfiles, 'models' => $deviceModels,
            'columns' => $deviceTableColumns]);

        $datatable = $this->datatableFactory->create($class);
        $datatable->buildDatatable($data);

        return $datatable;

    }

    /**
     * @param string $class
     * @param array $data
     * @return DatatableInterface
     * @throws \Exception
     */
    public function getAlertDatatable(string $class = AlertDatatable::class, array $data = []): DatatableInterface {

        $targetTypes = $this->managerRegistry->getRepository(AlertTargetType::class)->findAll();
        $targetSpecs = $this->managerRegistry->getRepository(AlertTargetSpec::class)->findAll();
        $monitoringGroups = $this->managerRegistry->getRepository(MonitoringGroup::class)->findAll();
        $devices = $this->managerRegistry->getRepository(Device::class)->getDevices();

        //Unset undefined value
        unset($targetTypes[0]);
        unset($targetSpecs[0]);

        $data = array_merge($data, ['targetTypes' => $targetTypes, 'targetSpecs' => $targetSpecs,
            'monitoringGroups' => $monitoringGroups, 'devices' => $devices]);

        $datatable = $this->datatableFactory->create($class);
        $datatable->buildDatatable($data);

        return $datatable;

    }

}
