<?php

declare(strict_types=1);

namespace App\Entity\CustomScript;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'custom_scripts')]
#[ORM\Entity]
class CustomScript implements \Stringable
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: Types::STRING, length: 512, unique: true, nullable: false)]
    public string $description;

    /**
     * @var string
     */
    #[ORM\Column(type: Types::STRING, length: 4096, nullable: false)]
    public string $code;

    /**
     * @var int
     */
    #[ORM\Column(type: Types::INTEGER, nullable: false, options: ['default' => 1])]
    public int $version = 1;

    /**
     * @var bool
     */
    #[ORM\Column(type: Types::BOOLEAN, nullable: false, options: ['default' => false])]
    public bool $deleted = false;

    /**
     * @var \DateTime
     */
    #[ORM\Column(name: 'last_update', type: Types::DATETIME_MUTABLE, options: ['default' => 'CURRENT_TIMESTAMP'])]
    public \DateTime $lastUpdate;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'script', targetEntity: CustomScriptDevTypeMap::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $devTypeMaps;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(mappedBy: 'script', targetEntity: CustomScriptAgentProfileMap::class, cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $agentProfileMap;

    /**
     * CustomScript constructor
     */
    public function __construct() {

        $this->lastUpdate = new \DateTime();
        $this->devTypeMaps = new ArrayCollection();
        $this->agentProfileMap = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getDescription(): string
    {
        return $this->description;
    }

    /**
     * @param string $description
     */
    public function setDescription(string $description): void
    {
        $this->description = $description;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @param string $code
     */
    public function setCode(string $code): void
    {
        $this->code = $code;
    }

    /**
     * @return bool
     */
    public function isDeleted(): bool
    {
        return $this->deleted;
    }

    /**
     * @param bool $deleted
     */
    public function setDeleted(bool $deleted): void
    {
        $this->deleted = $deleted;
    }

    /**
     * @return Collection<int, CustomScriptDevTypeMap>
     */
    public function getDevTypeMaps(): Collection
    {
        return $this->devTypeMaps;
    }

    /**
     * @param Collection $devTypeMaps
     */
    public function setDevTypeMaps(Collection $devTypeMaps): void
    {
        $this->devTypeMaps = $devTypeMaps;
    }

    /**
     * @return Collection<int, CustomScriptAgentProfileMap>
     */
    public function getAgentProfileMap(): Collection
    {
        return $this->agentProfileMap;
    }

    /**
     * @param Collection $agentProfileMap
     */
    public function setAgentProfileMap(Collection $agentProfileMap): void
    {
        $this->agentProfileMap = $agentProfileMap;
    }

    /**
     * @return int
     */
    public function getVersion(): int
    {
        return $this->version;
    }

    /**
     * @param int $version
     */
    public function setVersion(int $version): void
    {
        $this->version = $version;
    }

    /**
     * @return string
     */
    public function __toString(): string {

        return $this->description;

    }

}