<?php

namespace App\Form\Device;

use App\Entity\Device\Device;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class ConfigProfileCloneFromDeviceType extends AbstractType
{

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options){

        /** @var \App\Entity\Device\Device $device */
        $device = $options['data']['device'];
        $devicesToCloneFrom = $options['data']['devicesToCloneFrom'];
        $isCloned = $options['data']['isCloned'];

        $choices = [];
        $choicesAttr = [];

        foreach ($devicesToCloneFrom as $item) {

            $choices[$item['devid']] = $item['id'];
            $choicesAttr[$item['devid']] = ['data-description' => $item['name']];

        }

        $builder
            ->add('config_profile', ChoiceType::class ,array(
                'choices' => $choices,
                'choice_attr' => $choicesAttr,
                'placeholder' => 'Select a Device to clone from',
                'data' => ($device->configProfile) ? $device->configProfile->getId() : null,

            ))
            ->add('save', SubmitType::class, ['label' => 'Set ',
                'block_prefix' => 'modal_footer']);

        if($isCloned){

            $builder->add('no_clone', SubmitType::class, ['label' => 'Remove cloning']);

        }


    }

}