<?php

namespace App\Mailer;

use App\Service\ConfigurationService;
use Psr\EventDispatcher\EventDispatcherInterface;
use Psr\Log\LoggerInterface;
use Symfony\Component\Mailer\Transport\AbstractTransportFactory;
use Symfony\Component\Mailer\Transport\Dsn;
use Symfony\Component\Mailer\Transport\Smtp\EsmtpTransport;
use Symfony\Component\Mailer\Transport\TransportInterface;
use Symfony\Contracts\HttpClient\HttpClientInterface;

final class EsmtpTransportFactory extends AbstractTransportFactory
{

    /**
     * @var ConfigurationService
     */
    private ConfigurationService $configurationService;

    /**
     * @param EventDispatcherInterface|null $dispatcher
     * @param LoggerInterface|null $logger
     * @param ConfigurationService $configurationService
     */
    public function __construct(EventDispatcherInterface $dispatcher = null, HttpClientInterface $client = null,
                                LoggerInterface $logger = null, ConfigurationService $configurationService){

        parent::__construct($dispatcher, $client, $logger);

        $this->configurationService = $configurationService;

    }

    /**
     * @param Dsn $dsn
     * @return TransportInterface
     * @throws \Exception
     */
    public function create(Dsn $dsn): TransportInterface {

        $host = $this->configurationService->getSmtpServer();
        $port = $this->configurationService->getSmtpPort();
        $security = $this->configurationService->getSmtpSecurity();

        $tls = null;

        if($security === 0){
            $tls = null;
        }elseif ($security === 1){
            $tls = true;
        }elseif ($security === 2){
            $tls = false;
        }

        $transport = new EsmtpTransport( ((is_null($host)) ? '' : $host), $port, $tls, $this->dispatcher, $this->logger);

        $transport->setUsername((is_null($this->configurationService->getSmtpLogin())? '' : $this->configurationService->getSmtpLogin()) );
        $transport->setPassword((is_null($this->configurationService->getSmtpPassword() ? '' : $this->configurationService->getSmtpPassword())) );

        $stream = $transport->getStream();
        $streamOptions = $stream->getStreamOptions();

        $streamOptions['ssl']['verify_peer'] = false;
        //$streamOptions['ssl']['verify_peer_name'] = false;
        //$streamOptions['ssl']['allow_self_signed'] = true;
        //$streamOptions['ssl']['crypto_method'] = \STREAM_CRYPTO_PROTO_TLSv1_3;

        $stream->setStreamOptions($streamOptions);

        return $transport;

    }

    /**
     * @return string[]
     */
    protected function getSupportedSchemes(): array {

        return ['smtp'];

    }

}