<?php

declare(strict_types=1);

namespace App\Service\ConfigProfile;

use Shuchkin\SimpleXLSX;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

readonly class ConfigProfileService
{

    public function __construct(private ParameterBagInterface $params, private ConfigProfileManagerFactory $configProfileManagerFactory)
    {

		/*$books = [
			['test', '#!/bin/bash
			# Backup ~/Documents to ~/Backup with timestamp
			SRC=~/Documents
			DEST=~/Backup/Documents_$(date +%Y%m%d_%H%M%S)
			mkdir -p "$DEST"
			cp -r "$SRC"/* "$DEST"
			echo "Backup completed to $DEST" ' ]
		];
		$xlsx = SimpleXLSXGen::fromArray( $books );
		//$xlsx->saveAs(__DIR__ . '/test.xlsx'); // or downloadAs('books.xlsx') or $xlsx_content = (string) $xlsx

		if ( $xlsx = SimpleXLSX::parse(__DIR__.'\test.xlsx') ) {
			dump( $xlsx->rows() );
		} else {
			echo SimpleXLSX::parseError();
		}

		die();*/

    }

	public function getXlsxFile(array $profileData): string
	{

		//dump($profileData);
		//die();
		$xlsxGen = $this->configProfileManagerFactory->createXlsxGen();
		$xlsxGen->setTitle('Dwarfguard Config Profile Data');
		$xlsxGen->addSheet($this->formatDataForXlsx($profileData));

		//$xlsxGen->saveAs(__DIR__ . '/test.xlsx');
		return (string) $xlsxGen;

	}

	public function readXlsxFile(string $xlsxProfileData): bool|SimpleXLSX
	{

		$xlsxReader = $this->configProfileManagerFactory->createXlsx();

		if ($xlsxReader->unzip($xlsxProfileData, true)) {
			$xlsxReader->parseEntries();
		}

		if ($xlsxReader->success()) {
			return $xlsxReader;
		}

		return false;

	}

	private function formatDataForXlsx(array $profileData): array
	{

		$data = [];

		foreach($profileData as $value){
			$data[] = [$value->key, $value->value];
		}

		return $data;

	}

}
