<?php

namespace App\Service;

use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

class FfiService
{
    private string $scdKey;
    private ?object $ffi = null;

    public function __construct(string $projectDir, ParameterBagInterface $params)
    {

        $this->scdKey = $params->get('app.ffi.scdKey');

        if (class_exists(\FFI::class)) {

            $this->ffi = \FFI::cdef(file_get_contents($projectDir . "/libs/dwarflenc.h"), $projectDir . "/libs/libdwarflenc.so");

        }


    }

    /**
     * @throws \Exception
     */
    public function encode(string $text): array {

        if(!$this->ffi){
            return [$text, 0, 0, 0, 0];
        }

        $result = $this->ffi->dwarflenc_encode($this->ffi->DWARFLENC_MODE_RELAXED, $text, strlen($text),
            $this->scdKey, NULL, $this->ffi->DWARFLENC_SALT_RANDOM, $this->ffi->DWARFLENC_SALT_RANDOM,
            $this->ffi->DWARFLENC_SALT_RANDOM, $this->ffi->DWARFLENC_VERSION_LAST);

        if(is_null($result)){

            throw New \RuntimeException('Error encoding in library call.');
        }

        return [\FFI::string($result->data, $result->len), $result->salt, $result->pepper, $result->chilli, $result->version];

    }

}