<?php declare(strict_types=1);

namespace App\Datatables;

use Sg\DatatablesBundle\Datatable\Column\ActionColumn;
use Sg\DatatablesBundle\Datatable\Filter\SelectFilter;
use Sg\DatatablesBundle\Datatable\Filter\TextFilter;
use Sg\DatatablesBundle\Datatable\Column\Column;

/**
 * Class DataChangeLogDatatable
 * @package App\Datatables
 */
final class SwPackageDatatable extends BaseDatatable
{

    protected string $entity = \App\Entity\UserModule::class;
    protected string $name = 'user_module_datatable';

    /**
     * {@inheritdoc}
     */
    public function buildDatatable(array $options = array()): void
    {

        $userModules = $options['userModules'];

        parent::buildDatatable($options);

        $this->options->setOrder([0, 'asc']);

        $this->extensions->set(array(
            'buttons' => array(
                'create_buttons' => array(
                    $this->getRefreshButton()
                ),
            )
        ));

        $this->addIdColumn();

        $this->columnBuilder
            ->add('name', Column::class, array(
                'title' => 'Package Name',
                'width' => '100%;',
                'default_content' => 'Not Assigned',
                'filter' => array(SelectFilter::class, array(
                    'classes' => '',
                    'search_type' => 'eq',
                    'multiple' => false,
                    'select_options' => array('' => 'Any') + $this->getOptionsArrayFromEntities($userModules, 'name', 'name'),
                    'cancel_button' => true,
                ))
            ))
            ->add('version', Column::class, array(
                'title' => 'Version',
                'width' => '100%;',
                'default_content' => 'Not Assigned',
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
            ))
            ->add('Devices_count', Column::class, array(
                'title' => 'Devices count',
                'width' => '100%;',
                'dql' => '(SELECT COUNT({p}) FROM App:DeviceUserModule {p} 
                JOIN App:Device d with {p}.device = d.id
                WHERE {p}.userModule = usermodule.id)',
                'searchable' => false,
                'orderable' => true,
            ))
            ->add(null, ActionColumn::class, array(
                'title' => $this->translator->trans('sg.datatables.actions.column_name'),
                'width' => '100%;',
                'class_name' => 'row_device_actions',
                'actions' => array(
                    array(
                        'route' => 'admin_sw_package_device_list',
                        'route_parameters' => array(
                            'userModuleId' => 'id',
                        ),
                        'label' => 'List Devices',
                        'icon' => self::ICON_LIST,
                        'attributes' => array(
                            'rel' => 'tooltip',
                            'title' => $this->translator->trans('sg.datatables.actions.detail'),
                            'class' => 'btn btn-primary btn-xs',
                            'role' => 'button',
                        ),
                    ),

                ),
            ))

        ;
    }

}