<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'device_netdevs')]
#[ORM\Entity]
class DeviceNetDev
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var int
     */
    #[ORM\Column(name: 'id_device', type: 'integer')]
    public int $devId;

    /**
     * @var int
     */
    #[ORM\Column(name: 'version', type: 'integer', nullable: true)]
    public int $version;

    /**
     * @var string|null
     */
    #[ORM\Column(type: 'string', length: 32, nullable: true)]
    public ?string $label = null;

    /**
     * @var bool|null
     */
    #[ORM\Column(type: 'boolean', nullable: true)]
    public ?bool $active = null;

    /**
     * @var bool|null
     */
    #[ORM\Column(type: 'boolean', nullable: true)]
    public ?bool $isLinkable = null;

    /**
     * @var bool|null
     */
    #[ORM\Column(type: 'boolean', nullable: true)]
    public ?bool $isCellular = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: 'string', length: 20, nullable: true)]
    public ?string $mac = null;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'ipaddr', type: 'string', length: 16, nullable: true)]
    public ?string $ipAddr = null;

    /**
     * @var int
     */
    #[ORM\Column(name: 'ipmask', type: 'integer', nullable: true)]
    public ?int $ipMask = null;

    /**
     * @var string|null
     */
    #[ORM\Column(name: 'ip6addr', type: 'string', length: 32, nullable: true)]
    public ?string $ip6Addr = null;

    /**
     * @var int
     */
    #[ORM\Column(name: 'ip6pref', type: 'integer', nullable: false)]
    public int $ip6Pref;

    /**
     * @var int
     */
    #[ORM\Column(type: 'integer', nullable: false)]
    public int $collisions;

    /**
     * @var int
     */
    #[ORM\Column(type: 'integer', nullable: false)]
    public int $rxPackets;

    /**
     * @var int
     */
    #[ORM\Column(type: 'integer', nullable: false)]
    public int $rxBytes;

    /**
     * @var int
     */
    #[ORM\Column(type: 'integer', nullable: false)]
    public int $rxErrors;

    /**
     * @var int
     */
    #[ORM\Column(type: 'integer', nullable: false)]
    public int $txPackets;

    /**
     * @var int
     */
    #[ORM\Column(type: 'integer', nullable: false)]
    public int $txBytes;

    /**
     * @var int
     */
    #[ORM\Column(type: 'integer', nullable: false)]
    public int $txErrors;

    /**
     * @var Device
     */
    #[ORM\ManyToOne(targetEntity: \App\Entity\Device::class, inversedBy: 'netDevices')]
    #[ORM\JoinColumn(name: 'id_device', referencedColumnName: 'id_device')]
    public Device $device;

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string|null
     */
    public function getLabel(): ?string {

        return $this->label;

    }

    /**
     * @return bool|null
     */
    public function getIsLinkable(): ?bool
    {
        return $this->isLinkable;
    }

    /**
     * @param bool|null $isLinkable
     */
    public function setIsLinkable(?bool $isLinkable): void
    {
        $this->isLinkable = $isLinkable;
    }

    /**
     * @return bool|null
     */
    public function getIsCellular(): ?bool
    {
        return $this->isCellular;
    }

    /**
     * @param bool|null $isCellular
     */
    public function setIsCellular(?bool $isCellular): void
    {
        $this->isCellular = $isCellular;
    }

}