<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'device_os_versions')]
#[ORM\Entity]
class DeviceOsVersion implements \Stringable
{

	final public const ENTITY_TABLE_NAME = 'device_os_versions';

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var DeviceOsType
     */
    #[ORM\ManyToOne(targetEntity: 'DeviceOsType', inversedBy: 'osVersions')]
    #[ORM\JoinColumn(name: 'os_type')]
    public DeviceOsType $osType;

    /**
     * @var string
     */
    #[ORM\Column(name: 'description', type: 'string', length: 32, nullable: false)]
    public string $version;

    /**
     * @var bool
     */
    #[ORM\Column(type: 'boolean', options: ['default' => 0])]
    public bool $available = false;

    /**
     * @var bool
     */
    #[ORM\Column(type: 'boolean', options: ['default' => 0])]
    public bool $approved = false;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: 'Device', mappedBy: 'osVer', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $devices;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: 'Device', mappedBy: 'osVerDesired', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $devicesDesired;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: ConfigProfile\ConfigProfile::class, mappedBy: 'osVersion', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $configProfiles;

    /**
     * OsVersion constructor.
     */
    public function __construct() {

        $this->devices = new ArrayCollection();
        $this->devicesDesired = new ArrayCollection();
        $this->configProfiles = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return DeviceOsType|null
     */
    public function getOsType(): ?DeviceOsType {

        return $this->osType;

    }

    /**
     * @param mixed $osType
     */
    public function setOsType(DeviceOsType $osType): void {

        $this->osType = $osType;

    }

    /**
     * @return string
     */
    public function getVersion(): string {

        return $this->version;

    }

    /**
     * @return string
     */
    public function getDescription(): string {

        return $this->version;

    }

    /**
     * @param mixed $version
     */
    public function setDescription(string $version): void {

        $this->version = $version;

    }

    /**
     * @return bool
     */
    public function getAvailable(): bool {

        return $this->available;

    }

    /**
     * @return bool
     */
    public function getApproved(): bool {

        return $this->approved;

    }

    /**
     * @return string
     */
    public function __toString(): string {

        return $this->getVersion();

    }

}