<?php

namespace App\Repository;

use App\Entity\TunnelOperation;
use App\Entity\TunnelStatus;
use App\Entity\TunnelWeb;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method TunnelWeb|null find($id, $lockMode = null, $lockVersion = null)
 * @method TunnelWeb|null findOneBy(array $criteria, array $orderBy = null)
 * @method TunnelWeb[]    findAll()
 * @method TunnelWeb[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class TunnelWebRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, TunnelWeb::class);
    }

    /**
     * @param int $webTunnelId
     * @param string $operationName
     * @return bool
     */
    public function processRequestOperation(int $webTunnelId, string $operationName): bool {

        $webTunnel = $this->findOneBy(['id' => $webTunnelId]);

        if ($webTunnel) {

            $entityManager = $this->getEntityManager();
            $operation = $entityManager->getRepository(TunnelOperation::class)
                ->findOneBy(['name' => $operationName]);
            $webTunnel->setRequestedOperation($operation);
            $entityManager->persist($webTunnel);
            $entityManager->flush();

            return true;

        }

        return false;

    }

}
