<?php

declare(strict_types=1);

namespace App\Controller\Admin\Ajax;

use App\Entity\AgentProfile\AgentProfile;
use App\Service\Api\AgentProfiles;
use Doctrine\Persistence\ManagerRegistry;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController as Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/admin/ajax/agent-profile', name: 'ajax_agent_profile')]
class AgentProfileController extends Controller
{

    /**
     * Delete Agent Profile
     * @return Response
     */
    #[Route(path: '/delete/{agentProfileId}', name: '_delete', methods: ['GET'])]
    public function agentProfileDeleteAction(Request $request, int $agentProfileId, ManagerRegistry $managerRegistry,
                                        AgentProfiles $agentProfilesApi): Response {

        if ($request->isXmlHttpRequest()) {

            $agentProfile = $managerRegistry->getRepository(AgentProfile::class)->findOneBy(['id' => $agentProfileId]);

            if($agentProfile){

                $agentProfilesApi->deleteAgentProfile($agentProfile->getId());

            }

            return new JsonResponse(['code' => 200, 'message' => 'Agent Profile was deleted', 'errors' => ['errors' => ['']]],
                200);

        }

        return new Response('Bad request.', 400);

    }

}