<?php

namespace App\Controller\Admin\Firmware;

use App\Bundles\Sg\DatatablesBundle\Response\DatatableResponse;
use App\Controller\Admin\BaseController;
use App\Datatables\FirmwareDatatable;
use App\Entity\DeviceOsType;
use App\Form\FwType;
use App\Repository\DeviceOsVersionRepository;
use Doctrine\Persistence\ManagerRegistry;
use Sg\DatatablesBundle\Datatable\DatatableFactory;
use Sg\DatatablesBundle\Response\DatatableQueryBuilder;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Response;
use Sg\DatatablesBundle\Datatable\DatatableInterface;

class FirmwareController extends BaseController
{

    /**
     * @return \Symfony\Component\HttpFoundation\JsonResponse|Response
     * @throws \Exception
     */
    #[Route(path: 'admin/firmware', name: 'admin_firmware')]
    public function firmware(Request                   $request, ManagerRegistry $managerRegistry, DatatableFactory $factory,
                             DatatableResponse         $responseService,
                             DeviceOsVersionRepository $osVersionRepository)
    {

        $deviceOsTypes = $managerRegistry->getRepository(DeviceOsType::class)->findAll();
        $osVersions = $osVersionRepository->getAvailableVersions();

        $isAjax = $request->isXmlHttpRequest();
        $this->filter = $request->query->get('column');

        /** @var DatatableInterface $datatable */
        $datatable = $factory->create(FirmwareDatatable::class);
        $datatable->buildDatatable(['osTypes' => $deviceOsTypes, 'osVersions' => $osVersions]);

        if ($isAjax) {
            $responseService->setDatatable($datatable);
            $requestParams = $this->getDatatableFilter($request, $datatable);
            $datatableQueryBuilder = new DatatableQueryBuilder($requestParams, $datatable);
            $responseService->setDatatableQueryBuilder($datatableQueryBuilder);

            return $responseService->getResponse();
        }

        $form = $this->createForm(FwType::class, ['osTypes' => $deviceOsTypes]);

        return $this->render('firmware/index.html.twig', ['datatable' => $datatable, 'filter' => $this->filter, 'form' => $form->createView()]);

    }

}