<?php

namespace App\Controller\Admin\MonitoringGroup;

use App\Bundles\Sg\DatatablesBundle\Response\DatatableResponse;
use App\Controller\Admin\BaseController;
use App\Datatables\DeviceInMonitoringGroupDatatable;
use App\Datatables\MonitoringGroupDatatable;
use App\Entity\DeviceType;
use App\Entity\Label;
use App\Entity\MonitoringGroup;
use App\Entity\DeviceOsType;
use App\Entity\DeviceOsVersion;
use App\Entity\DeviceSyncStatus;
use App\Exception\MonitoringGroupNotFoundException;
use App\Form\MonitoringGroupType;
use App\Service\DatatableService;
use Doctrine\ORM\QueryBuilder;
use Doctrine\Persistence\ManagerRegistry;
use Sg\DatatablesBundle\Datatable\DatatableFactory;
use App\Bundles\Sg\DatatablesBundle\Response\DatatableQueryBuilder;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Response;
use Sg\DatatablesBundle\Datatable\DatatableInterface;

class MonitoringGroupController extends BaseController
{

    /**
     * @return \Symfony\Component\HttpFoundation\JsonResponse|Response
     * @throws \Exception
     */
    #[Route(path: 'admin/monitoring-groups', name: 'admin_mongrp')]
    public function monitoringGroups(Request $request, DatatableFactory $factory,
                                     DatatableResponse $responseService)
    {

        $isAjax = $request->isXmlHttpRequest();
        $this->filter = $request->query->get('column');

        $datatable = $factory->create(MonitoringGroupDatatable::class);
        $datatable->buildDatatable();

        if ($isAjax) {
            $responseService->setDatatable($datatable);

            $requestParams = $this->getDatatableFilter($request, $datatable);
            $datatableQueryBuilder = new DatatableQueryBuilder($requestParams, $datatable);
            $responseService->setDatatableQueryBuilder($datatableQueryBuilder);

            return $responseService->getResponse();
        }

        $monitoringGroup = new MonitoringGroup();
        $form = $this->createForm(MonitoringGroupType::class, $monitoringGroup);

        return $this->render('monitoringGroup/index.html.twig', ['datatable' => $datatable, 'filter' => $this->filter, 'form' => $form->createView()]);

    }

    /**
     * @return \Symfony\Component\HttpFoundation\JsonResponse|Response
     * @throws \Exception
     */
    #[Route(path: 'admin/monitoring-group/{monitoringGroupId}', name: 'mntgrp_detail')]
    public function monitoringGroupDetail(Request $request, ManagerRegistry $managerRegistry,
                                          DatatableFactory $factory, DatatableResponse $responseService,
                                          DatatableService $datatableService,
                                          int $monitoringGroupId)
    {

        $isAjax = $request->isXmlHttpRequest();
        $this->filter = $request->query->get('column');

        $monitoringGroup = $managerRegistry->getRepository(MonitoringGroup::class)->find($monitoringGroupId);

        if(!$monitoringGroup){

            throw new MonitoringGroupNotFoundException();

        }

        $datatable = $datatableService->getDeviceDatatable(DeviceInMonitoringGroupDatatable::class, ['monitoringGroupId' => $monitoringGroupId]);

        if ($isAjax) {
            $responseService->setDatatable($datatable);

            $requestParams = $this->getDatatableFilter($request, $datatable);
            $datatableQueryBuilder = new DatatableQueryBuilder($requestParams, $datatable);
            $responseService->setDatatableQueryBuilder($datatableQueryBuilder);

            $qb = $datatableQueryBuilder->getQb();
            $qb->join('App:MonitoringGroupMapping', 'mgm',  \Doctrine\ORM\Query\Expr\Join::WITH,
                'vdevice.id = mgm.device');
            //$qb->join('App:MonitoringGroup', 'mg',  \Doctrine\ORM\Query\Expr\Join::WITH,
            //    'mgm.monitoringGroup = mg.id');
            $qb->andWhere('mgm.monitoringGroup = :id');
            $qb->andWhere('vdevice.deleted = :deleted');
            $qb->setParameter('deleted', '0');
            $qb->setParameter('id', $monitoringGroupId);

            return $responseService->getResponse();
        }

        return $this->render('monitoringGroup/detail.html.twig', ['datatable' => $datatable, 'filter' => $this->filter, 'mntGroupId' => $monitoringGroupId, 'mntGroup' => $monitoringGroup]);

    }

}