<?php

declare(strict_types=1);

namespace App\Entity\Alert;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'alert_table_selection')]
#[ORM\Entity]
class AlertTableSelection
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(name: 'table_selection', type: 'string', length: 64, nullable: false)]
    public string $tableName;

    /**
     * @var AlertTargetSpec
     */
    #[ORM\OneToMany(targetEntity: \App\Entity\Alert\AlertTargetSpec::class, mappedBy: 'selType', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $alertTargetSpec;

    /**
     * AlertTableSelection constructor
     */
    public function __construct() {

        $this->alertTargetSpec = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string
     */
    public function getTableName(): string {

        return $this->tableName;

    }

}