<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'device_os_types')]
#[ORM\Entity]
class DeviceOsType
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string
     */
    #[ORM\Column(type: 'string', length: 64, nullable: false, unique: true)]
    public string $name;

    /**
     * @var DeviceType|null
     */
    #[ORM\ManyToOne(targetEntity: \App\Entity\DeviceType::class, inversedBy: 'deviceOsTypes')]
    #[ORM\JoinColumn(name: 'dev_type')]
    public ?DeviceType $devType = null;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: 'DeviceOsVersion', mappedBy: 'osType', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $osVersions;

    /**
     * OsType constructor
     */
    public function __construct() {

        $this->osVersions = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName(): string{

        return $this->name;

    }

    /**
     * @return DeviceType|null
     */
    public function getDevType(): ?DeviceType {

        return $this->devType;

    }

}