<?php

declare(strict_types=1);

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'agent_device_type_map')]
#[ORM\Entity]
class DeviceTypeAgentMapping
{

    /**
     * @var int|null
     */
    #[ORM\Column(type: 'integer')]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var DeviceAgent
     */
    #[ORM\ManyToOne(targetEntity: \App\Entity\DeviceAgent::class, inversedBy: 'deviceTypeAgentMappings')]
    #[ORM\JoinColumn(name: 'agent_id', referencedColumnName: 'id')]
    public DeviceAgent $deviceAgent;

    /**
     * @var DeviceType
     */
    #[ORM\ManyToOne(targetEntity: \App\Entity\DeviceType::class, inversedBy: 'deviceTypeAgentMappings')]
    #[ORM\JoinColumn(name: 'device_type_id', referencedColumnName: 'id')]
    public DeviceType $deviceType;

    /**
     * @return DeviceAgent
     */
    public function getDeviceAgent(): DeviceAgent {

        return $this->deviceAgent;

    }

    /**
     * @return DeviceType
     */
    public function getDeviceType(): DeviceType {

        return $this->deviceType;

    }

}