<?php

namespace App\Form\Device;

use App\Entity\MonitoringGroup;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class MonitoringGroupType extends AbstractType
{

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options){

        /** @var MonitoringGroup $deviceMonitoringGroups */
        $deviceMonitoringGroups = $options['data']['deviceMonitoringGroups'];
        $monitoringGroups = $options['data']['monitoringGroups'];

        $selectedItems = [];

        foreach ($deviceMonitoringGroups as $item) {
            $selectedItems[] = $item->getMonitoringGroup()->getId();
        }

        $choices = [];

        foreach ($monitoringGroups as $item) {

            $choices[$item->getName()] = $item->getId();

        }

        $builder
            ->add('monitoringGroups', ChoiceType::class ,array(
                'choices' => $choices,
                'placeholder' => 'Select a Monitoring Group',
                'multiple' => true,
                'required' => false,
                'data' => $selectedItems,

            ))
            ->add('save', SubmitType::class, ['label' => 'Set ',
                'block_prefix' => 'modal_footer'])
        ;

    }

}