<?php

namespace App\Repository;

use App\Entity\ProductFlags;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method ProductFlags|null find($id, $lockMode = null, $lockVersion = null)
 * @method ProductFlags|null findOneBy(array $criteria, array $orderBy = null)
 * @method ProductFlags[]    findAll()
 * @method ProductFlags[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ProductFlagsRepository extends ServiceEntityRepository
{

    private const LICENSE_STATUS_ID = 'license_status';

    /**
     * @param ManagerRegistry $registry
     */
    public function __construct(ManagerRegistry $registry) {

        parent::__construct($registry, ProductFlags::class);

    }

    /**
     * @return ProductFlags|null
     */
    public function getUserDevchgVersion(): ?ProductFlags {

        return $this->findOneBy(['id' => 'user_devchg_version']);

    }

    /**
     * @return ProductFlags|null
     */
    public function getAboutInfo(): ?ProductFlags {

        return $this->findOneBy(['id' => 'about_info']);

    }

    /**
     * @return ProductFlags|null
     */
    public function getLicenseStatus(): ?ProductFlags {

        return $this->findOneBy(['id' => self::LICENSE_STATUS_ID]);

    }

    /**
     * @return ProductFlags|null
     */
    public function getProcessServerIpUpdate(): ?ProductFlags {

        //deprecated, gui do the complete change IP process by running sh script, multiple user can use this flag in the future
        //return $this->findOneBy(['id' => 'process_server_ip_update']);
        return null;

    }

    /**
     * @return void
     */
    public function incrementDevchgVersion(): void {

        $entityManager = $this->getEntityManager();

        $userDevchgVersion = $this->getUserDevchgVersion();
        $version = $userDevchgVersion->getVersion();
        $userDevchgVersion->setVersion($version + 1);

        $entityManager->persist($userDevchgVersion);
        $entityManager->flush();

    }

}
