APPDIR="/opt/adwarfg"
PERSDATADIR="$APPDIR/data"
TMPDATADIR="/tmp/dwarfg-tmp"
FN_AGENT_SCRIPT="dwarfg_agent.sh"
FN_SETTINGS_SERVA="server.ini"
FN_SETTINGS_GLOB="settings.ini"
FN_GLOGFILE="global_log.txt"
FN_LOGFILE="logfile.txt"
FN_PIDFILE="adwarfg_child.pid"
FN_WEBDATA="web_export.src"
FN_COUNTERS="counters.txt"
DWARFG_INIT="$APPDIR/etc/init"
AGENT="$APPDIR/bin/$FN_AGENT_SCRIPT"
DEF_SERVER=""
SETTINGS_SA="$PERSDATADIR/$FN_SETTINGS_SERVA"
SETTINGS_GL="$PERSDATADIR/$FN_SETTINGS_GLOB"
COUNTERS="$TMPDATADIR/$FN_COUNTERS"
PIDFILE="$PERSDATADIR/$FN_PIDFILE"
GLOGFILE="$PERSDATADIR/$FN_GLOGFILE"
WEBIMPORT="$PERSDATADIR/$FN_WEBDATA"
PINGOK=""
AGENTPID=0
AGENTSTATUS="$AGENTDOWN"
AGVER="$($AGENT -v)"

load_settings() {
  if [ -r $SETTINGS_SA ] ; then
    . $SETTINGS_SA
  fi
  for i in 1 2 3 4 5 6; do
    if [ -r $SETTINGS_GL  ] ; then
      . $SETTINGS_GL
    fi
    [ -n "$g_devid" ] && break
    sleep 1
  done
  if [ -r $COUNTERS ] ; then
    . $COUNTERS
  fi
  if [ -r $PIDFILE ] ; then
    read input<$PIDFILE
    AGENTPID=0
    case $input in
      ''|*[!0-9]*)
        :
        ;;
      *)
        [ 0 -ne $input ] && [ -d /proc/$input ] && AGENTPID=$input
    esac
  fi
}

export_loglevel() {
  MYTMP="/tmp/$FN_SETTINGS_GLOB.$$"
  touch $MYTMP || { echo "Unable to create temporary file, cannot change log level.<br>"; return; }
  cat $SETTINGS_GL | sed "s/g_alevel_debug=[0-9]*/g_alevel_debug=$g_alevel_debug/" | sed "s/g_alevel_log=[0-9]*/g_alevel_log=$g_alevel_log/" >$MYTMP
  mv $MYTMP $SETTINGS_GL || { echo "Unable to write to settings file ($SETTINGS_GL)"; return; }
}
