<?php

namespace App\Command;

use App\Service\MessageService;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\ConsoleOutputInterface;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(
    name: 'app:email-notification',
    description: 'Send Email notification.',
)]
class SendEmailNotificationCommand extends Command
{

    protected MessageService $messageService;

    /**
     * SendSlackNotificationCommand constructor.
     * @param MessageService $messageService
     */
    public function __construct(MessageService $messageService){

        parent::__construct();
        $this->messageService = $messageService;

    }

    /**
     * Configure
     */
    protected function configure(): void
    {

        // the full command description shown when running the command with
        // the "--help" option
        $this->setHelp('This command allows you to send Email notifications.');

        $this->addArgument('message', InputArgument::REQUIRED, 'The message for the user.');

    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int
     * @throws \Symfony\Component\Notifier\Exception\TransportExceptionInterface
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {

        $errOutput = $output instanceof ConsoleOutputInterface ? $output->getErrorOutput() : $output;

        // outputs multiple lines to the console (adding "\n" at the end of each line)
        $output->writeln([
            'Email notification',
            '==================',
            '',
        ]);

        $message = $input->getArgument('message');

        try{

            $result = $this->messageService->sendEmail($message);

            if ($result) {

                $output->writeln('Message successfully sent.');
                return Command::SUCCESS;

            }

        }catch (\Exception $exception){

            $errOutput->writeln($exception->getMessage());

        }

        //$output->writeln('Message sent error.');

        // or return this if some error happened during the execution
        // (it's equivalent to returning int(1))
        return Command::FAILURE;
    }
    
}