<?php

declare(strict_types=1);

namespace App\Controller\Admin\Download;

use App\Service\Command;
use App\Service\ConfigurationService;
use Psr\Log\LoggerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController as Controller;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;
use Symfony\Component\Process\Exception\ProcessFailedException;
use Symfony\Component\Routing\Attribute\Route;

class LogDownloadController extends Controller
{

    public function __construct(private readonly ParameterBagInterface $params, private readonly LoggerInterface $logger)
    {
    }

    /**
     * @return Response
     */
    #[Route(path: 'download/log', name: 'log_download')]
    public function agents(Request $request, ConfigurationService $configurationService, Command $commandService): Response {

        try{

            $exitCode = $commandService->runGrabLogs();;

            if($exitCode === 0){

                $logsDownloadPath = $this->params->get('app.logsDownloadPath');
                $logFileName = $configurationService->getAggregatedLogsFileName();

                $file = $logsDownloadPath . DIRECTORY_SEPARATOR . $logFileName;

                $response = new BinaryFileResponse($file);
                $response->setContentDisposition(
                    ResponseHeaderBag::DISPOSITION_ATTACHMENT,
                    $logFileName
                );

                return $response;

            }

        }catch (ProcessFailedException $exception){

            $this->logger->error($exception->getMessage(), ['trace' => $exception->getTraceAsString()]);

        }

        $referer = $request->headers->get('referer');

        if($referer){

            $this->addFlash(
                'danger',
                'Log download failed.'
            );
            return new RedirectResponse($referer);

        }

        $this->logger->error('Log download failed', ['exitCode' => $exitCode]);
        die('Log download failed.');

    }

}