<?php

namespace App\DataTable;

use Doctrine\ORM\Mapping\Entity;
use Sg\DatatablesBundle\Datatable\AbstractDatatable;
use Sg\DatatablesBundle\Datatable\Column\Column;
use Sg\DatatablesBundle\Datatable\Filter\TextFilter;
use Sg\DatatablesBundle\Datatable\Style;

/**
 * ClassBaseDatatable
 * @package App\Datatables
 */
abstract class BaseDatatable extends AbstractDatatable
{

    public const ICON_DETAIL = 'fa fa-eye';
    public const ICON_DELETE = 'fas fa-trash';
    public const ICON_LIST = ' fas fa-th-list';
    public const ICON_EDIT = ' fas fa-pen';
    public const ICON_DOWNLOAD = ' fas fa-download';
    public const ICON_UPLOAD = ' fas fa-upload';
	public const ICON_MANAGE = ' fas fa-indent';
    //public const DATETIME_FORMAT = 'DD.MM.YYYY, HH:mm:ss'; //used by momentum
    public const DATETIME_FORMAT = 'd.m.Y, H:i:s';

    /**
     * @var string
     */
    protected string $entity;

    /**
     * @var string
     */
    protected string $name;

	/**
	 * {@inheritdoc}
	 * @throws \Exception
	 */
    public function buildDatatable(array $options = []): void
    {
        $this->language->set([
            'cdn_language_by_locale' => false,
        ]);

        $this->ajax->set([]);

		$this->options->set([
			//'dom' => 'Bfrtip',
			'dom' => '<"dt-top"Bfi>rt<"dt-layout-row"l><"dt-layout-cell dt-layout-end"p><"clear">',
			'classes' => Style::BOOTSTRAP_4_STYLE,
			'individual_filtering' => true,
			'individual_filtering_position' => 'head',
			'fixed_header' => true,
			//'fixed_columns' => '{start: 2,end: 1}',
			'order_cells_top' => true,
			'length_menu' => [10, 25, 50, 100, 500],
			'page_length' => 50,
		]);

        $this->features->set([
            'processing' => true,
            'scroll_x' => true,
        ]);

        $this->extensions->set([
            'select' => array(
                'blurable' => false,
                'class_name' => 'selected',
                'info' => true,
                'items' => 'row',
                'selector' => 'td, th',
                'style' => 'os',
            ),
            //'responsive' => true,
            'responsive' => array(
                //'details' => true,
                'details' => array(
                    'display' => array(
                        'template' => 'datatable/display.js.twig',
                        //'vars' => array('id' => '2', 'test' => 'new value'),
                    ),
                    'renderer' => array(
                        'template' => '/datatable/renderer.js.twig',
                    ),
                ),
            ),
        ]);
    }

    /**
     * Get User.
     *
     * @return mixed|null
     */
    protected function getUser(): mixed
    {

        if ($this->authorizationChecker->isGranted('IS_AUTHENTICATED_FULLY')) {
            return $this->securityToken->getToken()->getUser();
        } else {
            return null;
        }

    }

    /**
     * Is admin.
     *
     * @return bool
     */
    protected function isAdmin(): bool {

        return $this->authorizationChecker->isGranted('ROLE_ADMIN');

    }

    /**
     * @return bool
     */
    protected function isSuperAdmin(): bool {

        return $this->authorizationChecker->isGranted('ROLE_SUPER_ADMIN');

    }

    protected function addIdColumn(): void
    {

        $this->columnBuilder->add('id', Column::class, array(
            'title' => 'Id',
            'width' => '100%;',
            'class_name' => 'row_id',
            'searchable' => false,
            'filter' => array(TextFilter::class,
                array(
                    'cancel_button' => true,
                ),
            ),
        ));

    }

    /**
     * @return array
     */
    protected function getRefreshButton(): array
    {

        return array(
            'action' => array(
                'template' => '/datatable/button/refresh.js.twig',
                'vars' => array('tableName' => 'sg-datatables-' . $this->getName()),

            ),
            'class_name' => 'refresh',
            'name' => 'refresh',
            'text' => '<i class=\"fas fa-sync\"></i> Refresh',
            'title_attr' => 'Refresh',
        );

    }

    /**
     * @return array
     */
    protected function getAutoRefreshButton(): array
    {

        return array(
            'action' => array(
                'template' => '/datatable/button/autoRefresh.js.twig',
                'vars' => array('tableName' => 'sg-datatables-' . $this->getName()),

            ),
            'class_name' => 'auto-refresh',
            'name' => 'auto-refresh',
            'text' => '<i class=\"fas fa-sync\"></i> Auto Refresh',
            'title_attr' => 'Auto Refresh',
        );

    }

    /**
     * @return string
     */
    public function getEntity(): string
    {

        return $this->entity;

    }

    /**
     * @return string
     */
    public function getName(): string
    {

        return $this->name;

    }

    /**
     * @param array $array
     * @param string $keyName
     * @param string $valueName
     * @return array
     */
    protected function getOptionsFromArray(array $array, string $keyName, string $valueName): array
    {

        $options = [];

        foreach ($array as $item){

            $options[$item[$keyName]] = $item[$valueName];
        }

        return $options;

    }

}