<?php

namespace App\Event;

use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Contracts\EventDispatcher\Event;

class ButtonTypeEventLogEvent extends Event
{
    public const NAME = 'button.type.event.log.event';

	public function __construct(
		private readonly UserInterface $user,
		private readonly int           $buttonId,
		private readonly ?string 	   $message = null
	) {

	}

	/**
	 * @return UserInterface
	 */
	public function getUser(): UserInterface
	{
		return $this->user;
	}

	/**
	 * @return int
	 */
	public function getButtonId(): int
	{
		return $this->buttonId;
	}

	/**
	 * @return string|null
	 */
	public function getMessage(): ?string
	{
		return $this->message;
	}
}
