<?php declare(strict_types=1);

namespace App\ValueObject;

final class Firmware
{

    private int $id;

    /** @var string */
    private string $name;
    private float $size;
    private string $created;

    public function __construct(int $id, string $name, float $size, string $created)
    {
        /* if ($amount < 0) {
            throw new \InvalidArgumentException("Amount should be a positive value: {$amount}.");
        }

        if (!in_array($currency, $this->getAvailableCurrencies())) {
            throw new \InvalidArgumentException("Currency should be a valid one: {$currency}.");
        }*/

        $this->id = $id;
        $this->name = $name;
        $this->size = $size;
        $this->created = $created;
    }

    private function getAvailableCurrencies(): array
    {
        return [self::USD, self::CAD];
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getSize(): float
    {
        return $this->size;
    }

    public function getCreated(): string
    {
        return $this->created;
    }

}


