<?php

declare(strict_types=1);

namespace App\Controller\Admin\Ajax;

use App\DataTable\DeviceDatatable;
use App\Service\ConfigurationService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController as Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route(path: '/admin/ajax/settings', name: 'ajax_settings_')]
class SettingsController extends Controller
{

	/**
	 * @param Request $request
	 * @param ConfigurationService $configurationService
	 * @return Response
	 */
    #[Route(path: '/device-table-columns', name: 'device_table_columns', methods: ['POST'])]
    public function createLabelAction(Request $request, ConfigurationService $configurationService): Response {

        if (!$request->isXmlHttpRequest()) {

            return new Response('Bad request.', 400);

        }

		$toSave = [];

        if (isset($request->request)) {

            $columns = (array) $request->request->getIterator('columns');
			if(array_key_exists('columns', $columns)){

				$columns = $columns['columns'];
				$availableColumns = array_keys(DeviceDatatable::availableColumns);

				foreach ($columns as $column){

					if(in_array($column, $availableColumns, false)){
						$toSave[] = $column;
					}

				}

			}

            if(empty($toSave)){
                $toSave = DeviceDatatable::showColumns;
				$message = 'Device Table Columns settings was set <b>to the default.</b>';
            }else{
				$message = 'Device Table Columns settings was updated.';
			}

            $configurationService->setDeviceTableColumns($toSave);

                return new JsonResponse([
                    'code' => 200,
					'success' => true,
                    'message' => $message,
                ],200);


        }

        return new JsonResponse([
            'code' => 400,
			'success' => false,
            'message' => 'error',
            ],400);
    }

}