<?php

namespace App\DBALType;

use App\ValueObject\Configuration;
use Doctrine\DBAL\Types\Type;
use Doctrine\DBAL\Platforms\AbstractPlatform;

/**
 * App Configuration type
 *
 * @author Lukas Krchnak <lukas_krchnak@uniqueweb.cz>
 */
class ConfigurationDBALType extends Type
{
    public const CONFIG_VALUE = 'app_config';

	/**
	 * @param array $column
	 * @param AbstractPlatform $platform
	 *
	 * @return string
	 */
    public function getSQLDeclaration(array $column, AbstractPlatform $platform): string
	{

        return 'ENUM("' . implode('","', Configuration::getPossibleValues()) . '")';

    }

	/**
	 * @param mixed $value
	 * @param AbstractPlatform $platform
	 *
	 * @return Configuration
	 */
    public function convertToPHPValue(mixed $value, AbstractPlatform $platform): mixed
	{

        return Configuration::fromString($value);

    }

	/**
	 * @param mixed $value
	 * @param AbstractPlatform $platform
	 *
	 * @return string
	 */
    public function convertToDatabaseValue(mixed $value, AbstractPlatform $platform): mixed
	{

        return (string) $value;

    }

    /**
     * @return string
     */
    public function getName(): string
	{

        return self::CONFIG_VALUE;

    }

}