<?php

namespace App\DataTable;

use App\Bundles\Sg\DatatablesBundle\Datatable\Column\DwarfgBooleanColumn;
use App\Entity\Alert\Alert;
use Sg\DatatablesBundle\Datatable\Column\ActionColumn;
use Sg\DatatablesBundle\Datatable\Column\BooleanColumn;
use Sg\DatatablesBundle\Datatable\Column\Column;
use Sg\DatatablesBundle\Datatable\Column\DateTimeColumn;
use Sg\DatatablesBundle\Datatable\Column\LinkColumn;
use Sg\DatatablesBundle\Datatable\Editable\SelectEditable;
use Sg\DatatablesBundle\Datatable\Editable\TextEditable;
use Sg\DatatablesBundle\Datatable\Filter\DateRangeFilter;
use Sg\DatatablesBundle\Datatable\Filter\SelectFilter;
use Sg\DatatablesBundle\Datatable\Filter\TextFilter;

/**
 * Class AlertDatatable
 * @package App\Datatables
 */
class AlertDatatable extends BaseDatatable
{

    protected string $entity = Alert::class;
    protected string $name = 'alerts_datatable';

    /**
     * {@inheritdoc}
     */
    public function buildDatatable(array $options = array()): void
    {

        $targetTypes = $options['targetTypes'];
        $targetSpecs = $options['targetSpecs'];
        $monitoringGroups = $options['monitoringGroups'];
        $devices = $options['devices'];

        parent::buildDatatable($options);

        $this->extensions->set(array(
            'buttons' => array(
                'create_buttons' => array(  // custom buttons
                    array(
                        'action' => array(
                            'template' => '/datatable/alert/createAlert.js.twig',
                            'vars' => array('link' =>  $this->router->generate('admin_alert_add')),
                        ),
                        'class_name' => 'btn-add',
                        'name' => 'addAlert',
                        'text' => '<i class=\"fa fa-plus\"></i> Create Alert',
                    ),
                    $this->getRefreshButton()
                ),
            )
        ));

        $this->addIdColumn();

        $this->columnBuilder
           // ->add('id', new ChildRow(), array('ajax' =>array('route' =>'ci_supply_by_chem', 'args' => array('id' => 'id')) ))

            ->add('name', Column::class, array(
                'title' => 'Name',
                'width' => '100%;',
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
                'editable' => array(TextEditable::class,
                    array(
                        'url' => 'app_datatables_edit',
                        'placeholder' => 'Edit value',
                        'empty_text' => 'None',
                        'editable_if' => function ($row) {
                            if ($this->getUser()) {
                                //if ($row['createdBy']['id'] == $this->getUser()->getId() or true === $this->isAdmin()) {
                                    return true;
                                //};
                            }

                            return true;
                        },
                        'mode' => 'inline',
                    ),
                ),
            ))

            ->add('targetType.name', Column::class, array(
                'title' => 'T. Type',
                'default_content' => '',
                'width' => '100%;',
                'dql' => "(SELECT REPLACE({att}.name, '#', alert.targetAmount) FROM App\Entity\Alert\AlertTargetType {att}   
                           where {att}.id = alert.targetType)",
                'filter' => array(SelectFilter::class,
                    array(
                        'search_type' => 'eq',
                        //'multiple' => true,
                        'select_options' => array('' => 'Any') + $this->getOptionsArrayFromEntities($targetTypes, 'name', 'name'),
                        'cancel_button' => true,
                    )
                ),
            ))

            ->add('targetMonitoringGroup.name', LinkColumn::class, array(
                'title' => 'M. Grp.',
                'default_content' => '',
                'width' => '100%;',
                'text' => function($row) { return $row['targetMonitoringGroup']['name']; },
                'route' => 'mntgrp_detail',
                'route_params' => function($row) {
                    return array(
                        'monitoringGroupId' => $row['targetMonitoringGroup']['id'],
                    );
                },
                'filter' => array(SelectFilter::class,
                    array(
                        'search_type' => 'eq',
                        //'multiple' => true,
                        'select_options' => array('' => 'Any') + $this->getOptionsArrayFromEntities($monitoringGroups, 'name', 'name'),
                        'cancel_button' => true,
                    )
                ),
            ))

            ->add('targetDevice.devId', LinkColumn::class, array(
                'title' => 'Dev.',
                'default_content' => '',
                'width' => '100%;',
                'text' => function($row) { return $row['targetDevice']['devId']; },
                'route' => 'admin_devices_detail',
                'route_params' => function($row) {
                    return array(
                        'deviceId' => $row['targetDevice']['id'],
                    );
                },
                'filter' => array(SelectFilter::class,
                    array(
                        'search_type' => 'eq',
                        //'multiple' => true,
                        'select_options' => array('' => 'Any') + $this->getOptionsFromArray($devices, 'id_device', 'devid'),
                        'cancel_button' => true,
                    )
                ),
            ))

            ->add('targetSpec.name', Column::class, array(
                'title' => 'T. Spec',
                'default_content' => '',
                'width' => '100%;',
                'filter' => array(SelectFilter::class,
                    array(
                        'search_type' => 'eq',
                        //'multiple' => true,
                        'select_options' => array('' => 'Any') + $this->getOptionsArrayFromEntities($targetSpecs, 'name', 'name'),
                        'cancel_button' => true,
                    )
                ),
            ))

            ->add('conditions', Column::class, array(
                'title' => 'Aggreg. Condition',
                'default_content' => '',
                'width' => '100%;',
                'class_name' => 'condition',
                'dql' => "(SELECT 
                    CASE
                        WHEN o.operands = 1 THEN
                         CONCAT(o.operatorText, ' ',
                            CASE
                               WHEN ats.selType = 0 THEN
                                    p.numFirst
                               ELSE
                                CASE
                                WHEN atsel.tableName = 'device_sync_statuses' THEN
                                     sstat.description
                                  WHEN atsel.tableName = 'liveness_time' THEN
                                     lt.description
                                  WHEN atsel.tableName = 'liveness_misscount' THEN
                                     lmc.description
                                  WHEN atsel.tableName = 'device_os_versions' THEN
                                     ov.version
                                  ELSE
                                  'unknown type'
                                 END 
                               END
                         )            
                        WHEN o.operands = 2 THEN
                         CONCAT(o.operatorText, ' ',
                            CASE
                            WHEN ats.selType = 0 THEN
                                    p.numFirst
                               ELSE
                                CASE
                                WHEN atsel.tableName = 'device_sync_statuses' THEN
                                     sstat.description
                                  WHEN atsel.tableName = 'liveness_time' THEN
                                     lt.description
                                  WHEN atsel.tableName = 'liveness_misscount' THEN
                                     lmc.description
                                  WHEN atsel.tableName = 'device_os_versions' THEN
                                     ov.version
                                  ELSE
                                  'unknown type'
                                 END 
                               END
                         
                         , ' ', o.operatorText2, ' ',  o.operatorText3, ' ', 
                         
                         CASE
                         WHEN ats.selType = 0 THEN
                                    p.numSecond
                               ELSE
                                CASE
                                WHEN atsel.tableName = 'device_sync_statuses' THEN
                                     sstat2.description
                                  WHEN atsel.tableName = 'liveness_time' THEN
                                     lt2.description
                                  WHEN atsel.tableName = 'liveness_misscount' THEN
                                     lmc2.description
                                  WHEN atsel.tableName = 'device_os_versions' THEN
                                     ov2.version
                                  ELSE
                                  'unknown type'
                                 END 
                               END
                         
                         )
                        ELSE
                        'uknown' 
                    END
                    FROM App\Entity\Alert\Alert {p} 
                left JOIN App\Entity\Types\TypesOperator {o} with {o}.id = {p}.operFirst
                left JOIN App\Entity\Types\TypesOperator {q} with {q}.id = {p}.operSecond 
                left JOIN App\Entity\Alert\AlertTargetSpec {ats} with {ats}.id = {p}.targetSpec
                left JOIN App\Entity\Alert\AlertTableSelection {atsel} with {atsel}.id = {ats}.selType
                left JOIN App\Entity\Device\DeviceSyncStatus {sstat} with {sstat}.id = {p}.numFirst
                left JOIN App\Entity\Types\LivenessTime {lt} with {lt}.id = {p}.numFirst
                left JOIN App\Entity\Types\LivenessMisscount {lmc} with {lmc}.id = {p}.numFirst
                left JOIN App\Entity\Device\DeviceOsVersion {ov} with {ov}.id = {p}.numFirst
                left JOIN App\Entity\Device\DeviceSyncStatus {sstat2} with {sstat2}.id = {p}.numSecond
                left JOIN App\Entity\Types\LivenessTime {lt2} with {lt2}.id = {p}.numSecond
                left JOIN App\Entity\Types\LivenessMisscount {lmc2} with {lmc2}.id = {p}.numSecond
                left JOIN App\Entity\Device\DeviceOsVersion {ov2} with {ov2}.id = {p}.numSecond
                 where {p}.id = alert.id )",
                'searchable' => false,
                'orderable' => false,

            ))

            ->add('active', BooleanColumn::class, array(
                'title' => 'Active',
                'width' => '100%;',
                'class_name' => 'row_actions',
                'true_label' => 'Active',
                'false_label' => 'Inactive',
                'false_icon' => 'fa fa-circle yellow',
                'filter' => array(SelectFilter::class,
                    array(
                        'search_type' => 'eq',
                        //'multiple' => true,
                        'select_options' => array(
                            '' => 'Any',
                            '1' => 'Yes',
                            '0' => 'No',
                        ),
                        'cancel_button' => true,
                    )
                ),
            ))

            ->add('triggered', DwarfgBooleanColumn::class, array(
                'title' => 'Trig.',
                'width' => '100%;',
                'true_label' => 'List devices',
                'false_label' => 'No',
                'true_icon' => 'fa fa-circle red',
                //'false_icon' => '',
                'true_label_route' => 'admin_devices_triggered_alert',
                'true_label_route_parameters' => ['alertId' => 'id'],
                'filter' => array(SelectFilter::class,
                    array(
                        'search_type' => 'eq',
                        'select_options' => array(
                            '' => 'Any',
                            '1' => 'Yes',
                            '0' => 'No',
                        ),
                        'cancel_button' => true,
                    )
                ),
            ))

            ->add('lastTriggerTime', DateTimeColumn::class, array(
                'title' => 'Trig. time',
                'default_content' => 'Never',
                'width' => '100%;',
                'date_format' => self::DATETIME_FORMAT,
                'filter' => array(DateRangeFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
            ))

            ->add('counter', Column::class, array(
                'title' => 'Count.',
                'default_content' => '',
                'width' => '100%;',
                'filter' => array(TextFilter::class,
                    array(
                        'cancel_button' => true,
                    ),
                ),
            ))

            ->add('enabled', BooleanColumn::class, array(
                'title' => 'Enabled',
                'width' => '100%;',
                'true_label' => 'Enabled',
                'false_label' => 'Disabled',
                'filter' => array(SelectFilter::class,
                    array(
                        'search_type' => 'eq',
                        //'multiple' => true,
                        'select_options' => array(
                            '' => 'Any',
                            '1' => 'Yes',
                            '0' => 'No',
                        ),
                        'cancel_button' => true,
                    )
                ),
                'editable' => array(SelectEditable::class,
                    array(
                        'editable_if' => function ($row) {
                            if ($this->getUser()) {
                                // if ($row['createdBy']['id'] == $this->getUser()->getId() or true === $this->isAdmin()) {
                                return true;
                                // };
                            }

                            return false;
                        },
                        'source' => array(
                            array('value' => 1, 'text' => 'Yes'),
                            array('value' => 0, 'text' => 'No'),
                        ),
                        'mode' => 'inline',
                        'empty_text' => '',
                    ),
                ),
            ))

            ->add(null, ActionColumn::class, array(
                'title' => $this->translator->trans('sg.datatables.actions.column_name'),
                'width' => '100%;',
                'actions' => array(
                    array(
                        'route' => 'admin_alert_edit',
                        'route_parameters' => array(
                            'alertId' => 'id',
                        ),
                        'label' => $this->translator->trans('sg.datatables.actions.edit'),
                        'icon' => self::ICON_DETAIL,
                        'attributes' => array(
                            'rel' => 'tooltip',
                            'title' => $this->translator->trans('sg.datatables.actions.edit'),
                            'class' => 'btn btn-primary btn-xs',
                            'role' => 'button',
                        ),
                    ),

                ),
            ))

        ;
    }

}