<?php

declare(strict_types=1);

namespace App\Entity\Device;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'device_notes')]
#[ORM\Entity]
class DeviceNote {

    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $idDevice = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: true, options: ['datatable_editable' => true])]
    public ?string $note1 = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: true, options: ['datatable_editable' => true])]
    public ?string $note2 = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: true, options: ['datatable_editable' => true])]
    public ?string $note3 = null;

    /**
     * @var Device
     */
    #[ORM\OneToOne(targetEntity: Device::class, inversedBy: 'noteDevice')]
    #[ORM\JoinColumn(name: 'id_device', referencedColumnName: 'id_device', nullable: true)]
    public Device $device;

    /**
     * @return int|null
     */
    public function getId(): ?int {
        return $this->idDevice;
    }

	/**
	 * @return string|null
	 */
	public function getNote1(): ?string
	{
		return $this->note1;
	}

	/**
	 * @param string|null $note1
	 */
	public function setNote1(?string $note1): void
	{
		$this->note1 = $note1;
	}

	/**
	 * @return string|null
	 */
	public function getNote2(): ?string
	{
		return $this->note2;
	}

	/**
	 * @param string|null $note2
	 */
	public function setNote2(?string $note2): void
	{
		$this->note2 = $note2;
	}

	/**
	 * @return string|null
	 */
	public function getNote3(): ?string
	{
		return $this->note3;
	}

	/**
	 * @param string|null $note3
	 */
	public function setNote3(?string $note3): void
	{
		$this->note3 = $note3;
	}

}
