<?php

declare(strict_types=1);

namespace App\Entity\Tool;

use App\Entity\Device\Device;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'auth_profiles')]
#[ORM\Entity]
class AuthProfile
{
    /**
     * @var int|null
     */
    #[ORM\Column(type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    private ?int $id = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: true, options: ['datatable_editable' => true])]
    public ?string $profileName = null;

    /**
     * @var string
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: false)]
    public string $username;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::STRING, length: 64, nullable: true)]
    public ?string $sshPwd = null;

	/**
	 * @var int|null
	 */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $pwdSalt = null;

	/**
	 * @var int|null
	 */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $pwdPepper = null;

	/**
	 * @var int|null
	 */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $pwdChilli = null;

	/**
	 * @var int|null
	 */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $pwdVersion = null;

    /**
     * @var string|null
     */
    #[ORM\Column(type: Types::TEXT, nullable: true)]
    public ?string $sshKey = null;

	/**
	 * @var int|null
	 */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $keySalt = null;

	/**
	 * @var int|null
	 */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $keyPepper = null;

	/**
	 * @var int|null
	 */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $keyChilli = null;

	/**
	 * @var int|null
	 */
    #[ORM\Column(type: Types::INTEGER, length: 11, nullable: true)]
    public ?int $keyVersion = null;

    /**
     * @var Collection
     */
    #[ORM\OneToMany(targetEntity: Device::class, mappedBy: 'authProfile', cascade: ['persist'])]
    #[ORM\JoinColumn(name: 'id')]
    public Collection $devices;

    public function __construct() {

        $this->devices = new ArrayCollection();

    }

    /**
     * @return int|null
     */
    public function getId(): ?int {

        return $this->id;

    }

    /**
     * @return string|null
     */
    public function getProfileName(): ?string
    {
        return $this->profileName;
    }

    /**
     * @param string|null $profileName
     */
    public function setProfileName(?string $profileName): void
    {
        $this->profileName = $profileName;
    }

    /**
     * @return string
     */
    public function getUsername(): string
    {
        return $this->username;
    }

    /**
     * @param string $username
     */
    public function setUsername(string $username): void
    {
        $this->username = $username;
    }

    /**
     * @return string|null
     */
    public function getSshPwd(): ?string
    {
        return $this->sshPwd;
    }

    /**
     * @param string|null $sshPwd
     */
    public function setSshPwd(?string $sshPwd): void
    {
        $this->sshPwd = $sshPwd;
    }

	/**
	 * @return int|null
	 */
    public function getPwdSalt(): ?int
    {
        return $this->pwdSalt;
    }

	/**
	 * @param int|null $pwdSalt
	 */
    public function setPwdSalt(?int $pwdSalt): void
    {
        $this->pwdSalt = $pwdSalt;
    }

	/**
	 * @return int|null
	 */
    public function getPwdPepper(): ?int
    {
        return $this->pwdPepper;
    }

	/**
	 * @param int|null $pwdPepper
	 */
    public function setPwdPepper(?int $pwdPepper): void
    {
        $this->pwdPepper = $pwdPepper;
    }

    /**
     * @return string|null
     */
    public function getPwdChilli(): ?int
    {
        return $this->pwdChilli;
    }

	/**
	 * @param int|null $pwdChilli
	 */
    public function setPwdChilli(?int $pwdChilli): void
    {
        $this->pwdChilli = $pwdChilli;
    }

    /**
     * @return string|null
     */
    public function getPwdVersion(): ?int
    {
        return $this->pwdVersion;
    }

	/**
	 * @param int|null $pwdVersion
	 */
    public function setPwdVersion(?int $pwdVersion): void
    {
        $this->pwdVersion = $pwdVersion;
    }

    /**
     * @return string|null
     */
    public function getSshKey(): ?string
    {
        return $this->sshKey;
    }

    /**
     * @param string|null $sshKey
     */
    public function setSshKey(?string $sshKey): void
    {
        $this->sshKey = $sshKey;
    }

	/**
	 * @return int|null
	 */
    public function getKeySalt(): ?int
    {
        return $this->keySalt;
    }

	/**
	 * @param int|null $keySalt
	 */
    public function setKeySalt(?int $keySalt): void
    {
        $this->keySalt = $keySalt;
    }

	/**
	 * @return int|null
	 */
    public function getKeyPepper(): ?int
    {
        return $this->keyPepper;
    }

	/**
	 * @param int|null $keyPepper
	 */
    public function setKeyPepper(?int $keyPepper): void
    {
        $this->keyPepper = $keyPepper;
    }

	/**
	 * @return int|null
	 */
    public function getKeyChilli(): ?int
    {
        return $this->keyChilli;
    }

	/**
	 * @param int|null $keyChilli
	 */
    public function setKeyChilli(?int $keyChilli): void
    {
        $this->keyChilli = $keyChilli;
    }

	/**
	 * @return int|null
	 */
    public function getKeyVersion(): ?int
    {
        return $this->keyVersion;
    }

	/**
	 * @param int|null $keyVersion
	 */
    public function setKeyVersion(?int $keyVersion): void
    {
        $this->keyVersion = $keyVersion;
    }

}