<?php

namespace App\Entity\User;

use App\Entity\EventLog\EventLog;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Unique\UserBundle\Model\User as BaseUser;

#[ORM\Table(name: 'user')]
#[ORM\Entity]
#[UniqueEntity(fields: 'email', message: 'email_already_taken')]
class User extends BaseUser
{

	#[ORM\OneToMany(targetEntity: EventLog::class, mappedBy: 'userId', cascade: ['persist'])]
	#[ORM\JoinColumn(name: 'id')]
	public Collection $events;

    public function __construct()
    {
        parent::__construct();

		$this->events = new ArrayCollection();

    }
}