<?php

namespace App\EventListener;

use App\Exception\PublishedMessageException;
use Doctrine\ORM\EntityManagerInterface;
use Psr\Log\LoggerInterface;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Event\ExceptionEvent;
use Twig\Environment;

class PublishedMessageExceptionListener
{

    /** @var LoggerInterface */
    protected LoggerInterface $logger;

    /** @var EntityManagerInterface */
    protected EntityManagerInterface $em;

    /** @var Environment */
    protected Environment $twig;

    public function __construct(LoggerInterface $logger, EntityManagerInterface $entityManager, Environment $twig)
    {
        $this->logger = $logger;
        $this->em = $entityManager;
        $this->twig = $twig;
    }

    public function onKernelException(ExceptionEvent $event): void
    {
        $exception = $event->getThrowable();

        if (!$exception instanceof PublishedMessageException) {
            return;
        }

        $this->logger->error($exception->getMessage(), ['trace' => $exception->getTraceAsString()]);

        $response = new Response($this->twig->render('errors/custom-error.html.twig', ['message' => $exception->getMessage()]));

        $event->setResponse($response);

    }

}