<?php

namespace App\Repository;

use App\Entity\Device\Device;
use App\Entity\Device\DeviceUserModule;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method DeviceUserModule|null find($id, $lockMode = null, $lockVersion = null)
 * @method DeviceUserModule|null findOneBy(array $criteria, array $orderBy = null)
 * @method DeviceUserModule[]    findAll()
 * @method DeviceUserModule[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class DeviceUserModuleRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry){

        parent::__construct($registry, DeviceUserModule::class);

    }

    public function getDeviceUserModules(Device $device) {

        return $this->createQueryBuilder('um')
            ->join('um.userModule', 'userModule')
            ->where('um.device = :val')
            ->andWhere('userModule.hidden = 0')
            ->setParameter('val', $device)
            ->getQuery()
            ->getResult()
            ;

    }

}
