/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- View for searching through the IP addresses in devices UI table
--

DROP VIEW IF EXISTS vdevices;
CREATE VIEW vdevices AS
SELECT dev.*, GROUP_CONCAT(netdevs.label, '¯', netdevs.ipAddr, '¯', COALESCE(netdevs.ip6Addr, '')) as net_devs FROM devices dev LEFT JOIN (SELECT net.* FROM device_netdevs net WHERE net.active = 1 AND net.is_linkable = 1 AND (net.ipaddr IS NOT NULL OR net.ip6addr IS NOT NULL)) netdevs on dev.id_device = netdevs.id_device GROUP BY dev.id_device;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
