<?php

declare(strict_types=1);

namespace App\Controller\Admin\Api;

use App\Service\Api\ApiService;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController as Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route(path: '/admin/api', name: 'api_')]
class ApiController extends Controller
{
    public function __construct(private readonly ApiService $apiService)
    {
    }

    /**
     * Get Dwafguard Global Status
     * @param Request $request
     * @return JsonResponse|Response
     */
    #[Route(path: '/global-status', name: 'get_global_status', options: ['expose' => true], methods: ['GET'])]
    public function getGlobalStatus(Request $request): JsonResponse|Response
    {

        if (!$request->isXmlHttpRequest()) {

            $data = $this->apiService->getDashboardData();

            if ($data) {
                return new JsonResponse($data);
            }

            return new JsonResponse(['error' => 'No data given.', 'message' => 'No data given.']);
        }

        return new Response('Bad request.', 400);

    }

}